/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.config.server.ConfigServerProperties;
import org.springframework.cloud.config.server.EnvironmentController;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnWebApplication
public class ConfigServerMvcConfiguration {
    @Autowired
    private EnvironmentRepository repository;
    @Autowired
    private ConfigServerProperties server;
    @Autowired(required=false)
    private EnvironmentEncryptor environmentEncryptor;

    @Bean
    public EnvironmentController environmentController() {
        EnvironmentController controller = new EnvironmentController(this.repository, this.environmentEncryptor);
        controller.setDefaultLabel(this.getDefaultLabel());
        controller.setOverrides(this.server.getOverrides());
        controller.setStripDocumentFromYaml(this.server.isStripDocumentFromYaml());
        return controller;
    }

    private String getDefaultLabel() {
        if (StringUtils.hasText((String)this.server.getDefaultLabel())) {
            return this.server.getDefaultLabel();
        }
        return this.repository.getDefaultLabel();
    }
}

