/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@ConditionalOnMissingBean(value={EnvironmentRepository.class})
@EnableConfigurationProperties(value={ConfigServerProperties.class})
public class EnvironmentRepositoryConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.health.enabled"}, matchIfMissing=true)
    public ConfigServerHealthIndicator configServerHealthIndicator(EnvironmentRepository repository) {
        return new ConfigServerHealthIndicator(repository);
    }

    @Configuration
    @ConditionalOnMissingBean(value={EnvironmentRepository.class})
    protected static class GitRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;
        @Autowired
        private ConfigServerProperties server;

        protected GitRepositoryConfiguration() {
        }

        @Bean
        public EnvironmentRepository environmentRepository() {
            MultipleJGitEnvironmentRepository repository = new MultipleJGitEnvironmentRepository(this.environment);
            if (this.server.getDefaultLabel() != null) {
                repository.setDefaultLabel(this.server.getDefaultLabel());
            }
            return repository;
        }
    }

    @Configuration
    @Profile(value={"native"})
    protected static class NativeRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;

        protected NativeRepositoryConfiguration() {
        }

        @Bean
        public EnvironmentRepository environmentRepository() {
            return new NativeEnvironmentRepository(this.environment);
        }
    }

    @Configuration
    @Profile(value={"subversion"})
    protected static class SvnRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;
        @Autowired
        private ConfigServerProperties server;

        protected SvnRepositoryConfiguration() {
        }

        @Bean
        public EnvironmentRepository environmentRepository() {
            SvnKitEnvironmentRepository repository = new SvnKitEnvironmentRepository(this.environment);
            if (this.server.getDefaultLabel() != null) {
                repository.setDefaultLabel(this.server.getDefaultLabel());
            }
            return repository;
        }
    }
}

