/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.config.server.git")
public class MultipleJGitEnvironmentRepository
extends JGitEnvironmentRepository {
    private Map<String, PatternMatchingJGitEnvironmentRepository> repos = new LinkedHashMap<String, PatternMatchingJGitEnvironmentRepository>();
    private Map<String, JGitEnvironmentRepository> placeholders = new LinkedHashMap<String, JGitEnvironmentRepository>();

    public MultipleJGitEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        for (String name : this.repos.keySet()) {
            PatternMatchingJGitEnvironmentRepository repo = this.repos.get(name);
            repo.setEnvironment(this.getEnvironment());
            if (!StringUtils.hasText((String)repo.getName())) {
                repo.setName(name);
            }
            if (repo.getPattern() == null || repo.getPattern().length == 0) {
                repo.setPattern(new String[]{name});
            }
            if (this.getTimeout() != 0 && repo.getTimeout() == 0) {
                repo.setTimeout(this.getTimeout());
            }
            repo.afterPropertiesSet();
        }
    }

    public void setRepos(Map<String, PatternMatchingJGitEnvironmentRepository> repos) {
        this.repos.putAll(repos);
    }

    public Map<String, PatternMatchingJGitEnvironmentRepository> getRepos() {
        return this.repos;
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        for (PatternMatchingJGitEnvironmentRepository repository : this.repos.values()) {
            if (!repository.matches(application, profile, label)) continue;
            for (JGitEnvironmentRepository candidate : this.getRepositories(repository, application, profile, label)) {
                try {
                    Environment source = candidate.findOne(application, profile, label);
                    if (source == null) continue;
                    return candidate.getLocations(application, profile, label);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        JGitEnvironmentRepository candidate = this.getRepository(this, application, profile, label);
        if (candidate == this) {
            return super.getLocations(application, profile, label);
        }
        return candidate.getLocations(application, profile, label);
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        for (PatternMatchingJGitEnvironmentRepository repository : this.repos.values()) {
            if (!repository.matches(application, profile, label)) continue;
            for (JGitEnvironmentRepository candidate : this.getRepositories(repository, application, profile, label)) {
                try {
                    Environment source = candidate.findOne(application, profile, label);
                    if (source == null) continue;
                    return source;
                }
                catch (Exception e) {
                    this.logger.info((Object)("Cannot load configuration from " + candidate.getUri()));
                }
            }
        }
        JGitEnvironmentRepository candidate = this.getRepository(this, application, profile, label);
        if (candidate == this) {
            return super.findOne(application, profile, label);
        }
        return candidate.findOne(application, profile, label);
    }

    private List<JGitEnvironmentRepository> getRepositories(JGitEnvironmentRepository repository, String application, String profile, String label) {
        ArrayList<JGitEnvironmentRepository> list = new ArrayList<JGitEnvironmentRepository>();
        String[] profiles = profile == null ? new String[1] : StringUtils.commaDelimitedListToStringArray((String)profile);
        int i = profiles.length;
        while (i-- > 0) {
            list.add(this.getRepository(repository, application, profiles[i], label));
        }
        return list;
    }

    private JGitEnvironmentRepository getRepository(JGitEnvironmentRepository repository, String application, String profile, String label) {
        if (!repository.getUri().contains("{")) {
            return repository;
        }
        String key = repository.getUri();
        if (application != null) {
            key = key.replace("{application}", application);
        }
        if (profile != null) {
            key = key.replace("{profile}", profile);
        }
        if (label != null) {
            key = key.replace("{label}", label);
        }
        if (!this.placeholders.containsKey(key)) {
            this.placeholders.put(key, this.getRepository(repository, key));
        }
        return this.placeholders.get(key);
    }

    private JGitEnvironmentRepository getRepository(JGitEnvironmentRepository source, String uri) {
        JGitEnvironmentRepository repository = new JGitEnvironmentRepository(null);
        File basedir = repository.getBasedir();
        BeanUtils.copyProperties((Object)source, (Object)repository);
        repository.setUri(uri);
        repository.setBasedir(basedir);
        return repository;
    }

    public static class PatternMatchingJGitEnvironmentRepository
    extends JGitEnvironmentRepository {
        private String[] pattern = new String[0];
        private String name;

        public PatternMatchingJGitEnvironmentRepository() {
            super(null);
        }

        public PatternMatchingJGitEnvironmentRepository(String uri) {
            this();
            this.setUri(uri);
        }

        public boolean matches(String application, String profile, String label) {
            if (this.pattern == null || this.pattern.length == 0) {
                return false;
            }
            String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            int i = profiles.length;
            while (i-- > 0) {
                if (!PatternMatchUtils.simpleMatch((String[])this.pattern, (String)(String.valueOf(application) + "/" + profiles[i]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Environment findOne(String application, String profile, String label) {
            if (this.pattern == null || this.pattern.length == 0) {
                return null;
            }
            if (PatternMatchUtils.simpleMatch((String[])this.pattern, (String)(String.valueOf(application) + "/" + profile))) {
                return super.findOne(application, profile, label);
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getPattern() {
            return this.pattern;
        }

        public void setPattern(String[] pattern) {
            AbstractCollection patterns = new ArrayList<String>();
            ArrayList<String> otherProfiles = new ArrayList<String>();
            String[] stringArray = pattern;
            int n = pattern.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (p != null) {
                    if (!p.contains("/")) {
                        patterns.add(String.valueOf(p) + "/*");
                    }
                    if (!p.endsWith("*")) {
                        otherProfiles.add(String.valueOf(p) + ",*");
                    }
                }
                patterns.add(p);
                ++n2;
            }
            patterns.addAll(otherProfiles);
            if (!patterns.contains(null)) {
                patterns = new LinkedHashSet(patterns);
            }
            this.pattern = patterns.toArray(new String[0]);
        }
    }
}

