/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.PassthruEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.config.server.native")
public class NativeEnvironmentRepository
implements EnvironmentRepository,
SearchPathLocator {
    private static Log logger = LogFactory.getLog(NativeEnvironmentRepository.class);
    private static final String DEFAULT_LABEL = "master";
    private String[] searchLocations = new String[0];
    private boolean failOnError = false;
    private String version;
    private static final String[] DEFAULT_LOCATIONS = new String[]{"classpath:/", "classpath:/config/", "file:./", "file:./config/"};
    private ConfigurableEnvironment environment;

    public NativeEnvironmentRepository(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public String getDefaultLabel() {
        return DEFAULT_LABEL;
    }

    @Override
    public Environment findOne(String config, String profile, String label) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{PropertyPlaceholderAutoConfiguration.class});
        ConfigurableEnvironment environment = this.getEnvironment(profile);
        builder.environment(environment);
        builder.web(false).bannerMode(Banner.Mode.OFF);
        String[] args = this.getArgs(config, profile, label);
        builder.application().setListeners(Arrays.asList(new ConfigFileApplicationListener()));
        ConfigurableApplicationContext context = builder.run(args);
        environment.getPropertySources().remove("profiles");
        try {
            Environment environment2 = this.clean(new PassthruEnvironmentRepository(environment).findOne(config, profile, label));
            return environment2;
        }
        finally {
            context.close();
        }
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        String location;
        String[] locations = this.searchLocations;
        if (this.searchLocations == null || this.searchLocations.length == 0) {
            locations = DEFAULT_LOCATIONS;
        }
        ArrayList<String> output = new ArrayList<String>();
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            location = stringArray[n2];
            String[] profiles = new String[]{profile};
            if (profile != null) {
                profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            }
            String[] stringArray2 = profiles;
            int n3 = profiles.length;
            int n4 = 0;
            while (n4 < n3) {
                String prof = stringArray2[n4];
                String value = location;
                if (application != null) {
                    value = value.replace("{application}", application);
                }
                if (prof != null) {
                    value = value.replace("{profile}", prof);
                }
                if (label != null) {
                    value = value.replace("{label}", label);
                }
                if (!value.endsWith("/")) {
                    value = String.valueOf(value) + "/";
                }
                if (this.isDirectory(value)) {
                    output.add(value);
                }
                ++n4;
            }
            ++n2;
        }
        stringArray = locations;
        n = locations.length;
        n2 = 0;
        while (n2 < n) {
            String labelled;
            location = stringArray[n2];
            if (StringUtils.hasText((String)label) && this.isDirectory(labelled = String.valueOf(location) + label.trim() + "/")) {
                output.add(labelled);
            }
            ++n2;
        }
        return new SearchPathLocator.Locations(application, profile, label, this.version, output.toArray(new String[0]));
    }

    private ConfigurableEnvironment getEnvironment(String profile) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("profiles", Collections.singletonMap("spring.profiles.active", profile)));
        return environment;
    }

    protected Environment clean(Environment value) {
        Environment result = new Environment(value.getName(), value.getProfiles(), value.getLabel(), this.version);
        for (org.springframework.cloud.config.environment.PropertySource source : value.getPropertySources()) {
            String name = source.getName();
            if (this.environment.getPropertySources().contains(name)) continue;
            name = name.replace("applicationConfig: [", "");
            name = name.replace("]", "");
            if (this.searchLocations != null) {
                boolean matches = false;
                String normal = name;
                if (normal.startsWith("file:")) {
                    normal = StringUtils.cleanPath((String)new File(normal.substring("file:".length())).getAbsolutePath());
                }
                String profile = result.getProfiles() == null ? null : StringUtils.arrayToCommaDelimitedString((Object[])result.getProfiles());
                String[] stringArray = this.getLocations(result.getName(), profile, result.getLabel()).getLocations();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    if (!pattern.contains(":")) {
                        pattern = "file:" + pattern;
                    }
                    if (pattern.startsWith("file:")) {
                        pattern = String.valueOf(StringUtils.cleanPath((String)new File(pattern.substring("file:".length())).getAbsolutePath())) + "/";
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Testing pattern: " + pattern + " with property source: " + name));
                    }
                    if (normal.startsWith(pattern) && !normal.substring(pattern.length()).contains("/")) {
                        matches = true;
                        break;
                    }
                    ++n2;
                }
                if (!matches) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Not adding property source: " + name));
                    continue;
                }
            }
            logger.info((Object)("Adding property source: " + name));
            result.add(new org.springframework.cloud.config.environment.PropertySource(name, source.getSource()));
        }
        return result;
    }

    private String[] getArgs(String application, String profile, String label) {
        ArrayList<String> list = new ArrayList<String>();
        String config = application;
        if (!config.startsWith("application")) {
            config = "application," + config;
        }
        list.add("--spring.config.name=" + config);
        list.add("--spring.cloud.bootstrap.enabled=false");
        list.add("--encrypt.failOnError=" + this.failOnError);
        list.add("--spring.config.location=" + StringUtils.arrayToCommaDelimitedString((Object[])this.getLocations(application, profile, label).getLocations()));
        return list.toArray(new String[0]);
    }

    public String[] getSearchLocations() {
        return this.searchLocations;
    }

    public void setSearchLocations(String ... locations) {
        this.searchLocations = locations;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                String location = locations[i];
                if (this.isDirectory(location) && !location.endsWith("/")) {
                    location = String.valueOf(location) + "/";
                }
                locations[i] = location;
                ++i;
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private boolean isDirectory(String location) {
        return !location.contains("{") && !location.endsWith(".properties") && !location.endsWith(".yml") && !location.endsWith(".yaml");
    }
}

