/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"}, produces={"application/json"})
public class ResourceController {
    private ResourceRepository resourceRepository;
    private EnvironmentRepository environmentRepository;

    public ResourceController(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/{path:.*}"})
    public synchronized String resolve(@PathVariable String name, @PathVariable String profile, @PathVariable String label, @PathVariable String path) throws IOException {
        StandardEnvironment environment = new StandardEnvironment();
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        environment.getPropertySources().addAfter("systemProperties", (PropertySource)new EnvironmentPropertySource(this.environmentRepository.findOne(name, profile, label)));
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream is = this.resourceRepository.findOne(name, profile, label, path).getInputStream();){
            String text = StreamUtils.copyToString((InputStream)is, (Charset)Charset.forName("UTF-8"));
            text = text.replace("\\${", "$_{");
            return environment.resolvePlaceholders(text).replace("$_{", "${");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/{path:.*}"}, produces={"application/octet-stream"})
    public synchronized byte[] binary(@PathVariable String name, @PathVariable String profile, @PathVariable String label, @PathVariable String path) throws IOException {
        StandardEnvironment environment = new StandardEnvironment();
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        environment.getPropertySources().addAfter("systemProperties", (PropertySource)new EnvironmentPropertySource(this.environmentRepository.findOne(name, profile, label)));
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream is = this.resourceRepository.findOne(name, profile, label, path).getInputStream();){
            return StreamUtils.copyToByteArray((InputStream)is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @ExceptionHandler(value={NoSuchResourceException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound(NoSuchResourceException e) {
    }

    private static class EnvironmentPropertySource
    extends PropertySource<Environment> {
        public EnvironmentPropertySource(Environment sources) {
            super("cloudEnvironment", (Object)sources);
        }

        public Object getProperty(String name) {
            for (org.springframework.cloud.config.environment.PropertySource source : ((Environment)this.getSource()).getPropertySources()) {
                Map map = source.getSource();
                if (!map.containsKey(name)) continue;
                return map.get(name);
            }
            return null;
        }
    }
}

