/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class EnvironmentController {
    private static final String MAP_PREFIX = "map";
    private EnvironmentRepository repository;
    private ObjectMapper objectMapper;
    private boolean stripDocument = true;

    public EnvironmentController(EnvironmentRepository repository) {
        this(repository, new ObjectMapper());
    }

    public EnvironmentController(EnvironmentRepository repository, ObjectMapper objectMapper) {
        this.repository = repository;
        this.objectMapper = objectMapper;
    }

    public void setStripDocumentFromYaml(boolean stripDocument) {
        this.stripDocument = stripDocument;
    }

    @RequestMapping(value={"/{name}/{profiles:.*[^-].*}"})
    public Environment defaultLabel(@PathVariable String name, @PathVariable String profiles) {
        return this.labelled(name, profiles, null);
    }

    @RequestMapping(value={"/{name}/{profiles}/{label:.*}"})
    public Environment labelled(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) {
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        Environment environment = this.repository.findOne(name, profiles, label);
        return environment;
    }

    @RequestMapping(value={"/{name}-{profiles}.properties"})
    public ResponseEntity<String> properties(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        return this.labelledProperties(name, profiles, null, resolvePlaceholders);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.properties"})
    public ResponseEntity<String> labelledProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        this.validateNameAndProfiles(name, profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> properties = this.convertToProperties(environment);
        String propertiesString = this.getPropertiesString(properties);
        if (resolvePlaceholders) {
            propertiesString = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), propertiesString);
        }
        return this.getSuccess(propertiesString);
    }

    @RequestMapping(value={"{name}-{profiles}.json"})
    public ResponseEntity<String> jsonProperties(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        return this.labelledJsonProperties(name, profiles, null, resolvePlaceholders);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.json"})
    public ResponseEntity<String> labelledJsonProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        this.validateNameAndProfiles(name, profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> properties = this.convertToMap(environment);
        String json = this.objectMapper.writeValueAsString(properties);
        if (resolvePlaceholders) {
            json = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), json);
        }
        return this.getSuccess(json, MediaType.APPLICATION_JSON);
    }

    private String getPropertiesString(Map<String, Object> properties) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (output.length() > 0) {
                output.append("\n");
            }
            String line = entry.getKey() + ": " + entry.getValue();
            output.append(line);
        }
        return output.toString();
    }

    @RequestMapping(value={"/{name}-{profiles}.yml", "/{name}-{profiles}.yaml"})
    public ResponseEntity<String> yaml(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        return this.labelledYaml(name, profiles, null, resolvePlaceholders);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.yml", "/{label}/{name}-{profiles}.yaml"})
    public ResponseEntity<String> labelledYaml(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        this.validateNameAndProfiles(name, profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> result = this.convertToMap(environment);
        if (this.stripDocument && result.size() == 1 && result.keySet().iterator().next().equals("document")) {
            Object value = result.get("document");
            if (value instanceof Collection) {
                return this.getSuccess(new Yaml().dumpAs(value, Tag.SEQ, DumperOptions.FlowStyle.BLOCK));
            }
            return this.getSuccess(new Yaml().dumpAs(value, Tag.STR, DumperOptions.FlowStyle.BLOCK));
        }
        String yaml = new Yaml().dumpAsMap(result);
        if (resolvePlaceholders) {
            yaml = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), yaml);
        }
        return this.getSuccess(yaml);
    }

    private Map<String, Object> convertToMap(Environment input) throws BindException {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(target);
        Map<String, Object> data = this.convertToProperties(input);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : data.keySet()) {
            properties.put("map." + key, data.get(key));
        }
        this.addArrays(target, properties);
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addFirst((PropertySource)new MapPropertySource("properties", properties));
        factory.setPropertySources((PropertySources)propertySources);
        factory.bindPropertiesToTarget();
        Map result = (Map)target.get(MAP_PREFIX);
        return result == null ? new LinkedHashMap() : result;
    }

    @ExceptionHandler(value={NoSuchLabelException.class})
    public void noSuchLabel(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.NOT_FOUND.value());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void illegalArgument(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value());
    }

    private void validateNameAndProfiles(String name, String profiles) {
        if (name.contains("-") || profiles.contains("-")) {
            throw new IllegalArgumentException("Properties output not supported for name or profiles containing hyphens");
        }
    }

    private HttpHeaders getHttpHeaders(MediaType mediaType) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(mediaType);
        return httpHeaders;
    }

    private ResponseEntity<String> getSuccess(String body) {
        return new ResponseEntity((Object)body, (MultiValueMap)this.getHttpHeaders(MediaType.TEXT_PLAIN), HttpStatus.OK);
    }

    private ResponseEntity<String> getSuccess(String body, MediaType mediaType) {
        return new ResponseEntity((Object)body, (MultiValueMap)this.getHttpHeaders(mediaType), HttpStatus.OK);
    }

    private void addArrays(Map<String, Object> target, Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            int index = key.indexOf("[");
            Map<String, Object> current = target;
            if (index <= 0) continue;
            String stem = key.substring(0, index);
            String[] keys = StringUtils.delimitedListToStringArray((String)stem, (String)".");
            for (int i = 0; i < keys.length - 1; ++i) {
                Map map;
                if (current.get(keys[i]) == null) {
                    map = new LinkedHashMap();
                    current.put(keys[i], map);
                    current = map;
                    continue;
                }
                map = (Map)current.get(keys[i]);
                current = map;
            }
            String name = keys[keys.length - 1];
            if (current.get(name) == null) {
                current.put(name, new ArrayList());
            }
            List value = (List)current.get(name);
            int position = Integer.valueOf(key.substring(index + 1, key.indexOf("]")));
            while (position >= value.size()) {
                if (key.indexOf("].", index) > 0) {
                    value.add(new LinkedHashMap());
                    continue;
                }
                value.add("");
            }
        }
    }

    private Map<String, Object> convertToProperties(Environment profiles) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        ArrayList sources = new ArrayList(profiles.getPropertySources());
        Collections.reverse(sources);
        for (org.springframework.cloud.config.environment.PropertySource source : sources) {
            Map value = source.getSource();
            map.putAll(value);
        }
        this.postProcessProperties(map);
        return map;
    }

    private void postProcessProperties(Map<String, Object> propertiesMap) {
        Iterator<String> iter = propertiesMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equals("spring.profiles")) continue;
            iter.remove();
        }
    }
}

