/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.server.encryption.EncryptionTooWeakException;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;
import org.springframework.cloud.config.server.encryption.InvalidCipherException;
import org.springframework.cloud.config.server.encryption.KeyNotAvailableException;
import org.springframework.cloud.config.server.encryption.KeyNotInstalledException;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.cloud.context.encrypt.KeyFormatException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaKeyHolder;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"${spring.cloud.config.server.prefix:}"})
public class EncryptionController {
    private static Log logger = LogFactory.getLog(EncryptionController.class);
    private volatile TextEncryptorLocator encryptor;
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();
    private String defaultApplicationName = "application";
    private String defaultProfile = "default";

    public EncryptionController(TextEncryptorLocator encryptor) {
        this.encryptor = encryptor;
    }

    public void setDefaultApplicationName(String defaultApplicationName) {
        this.defaultApplicationName = defaultApplicationName;
    }

    public void setDefaultProfile(String defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    @RequestMapping(value={"/key"}, method={RequestMethod.GET})
    public String getPublicKey() {
        TextEncryptor encryptor = this.encryptor.locate(this.helper.getEncryptorKeys("application", "default", ""));
        if (!(encryptor instanceof RsaKeyHolder)) {
            throw new KeyNotAvailableException();
        }
        return ((RsaKeyHolder)encryptor).getPublicKey();
    }

    @RequestMapping(value={"/key/{name}/{profiles}"}, method={RequestMethod.GET})
    public String getPublicKey(@PathVariable String name, @PathVariable String profiles) {
        TextEncryptor encryptor = this.encryptor.locate(this.helper.getEncryptorKeys(name, profiles, ""));
        if (!(encryptor instanceof RsaKeyHolder)) {
            throw new KeyNotAvailableException();
        }
        return ((RsaKeyHolder)encryptor).getPublicKey();
    }

    @ExceptionHandler(value={KeyFormatException.class})
    public ResponseEntity<Map<String, Object>> keyFormat() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "BAD_REQUEST");
        body.put("description", "Key data not in correct format (PEM or jks keystore)");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={KeyNotAvailableException.class})
    public ResponseEntity<Map<String, Object>> keyUnavailable() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "NOT_FOUND");
        body.put("description", "No public key available");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"encrypt/status"}, method={RequestMethod.GET})
    public Map<String, Object> status() {
        this.checkEncryptorInstalled("application", "default");
        return Collections.singletonMap("status", "OK");
    }

    @RequestMapping(value={"encrypt"}, method={RequestMethod.POST})
    public String encrypt(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        return this.encrypt(this.defaultApplicationName, this.defaultProfile, data, type);
    }

    @RequestMapping(value={"/encrypt/{name}/{profiles}"}, method={RequestMethod.POST})
    public String encrypt(@PathVariable String name, @PathVariable String profiles, @RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        this.checkEncryptorInstalled(name, profiles);
        String input = this.stripFormData(data, type, false);
        Map<String, String> keys = this.helper.getEncryptorKeys(name, profiles, input);
        String textToEncrypt = this.helper.stripPrefix(input);
        String encrypted = this.helper.addPrefix(keys, this.encryptor.locate(keys).encrypt(textToEncrypt));
        logger.info((Object)"Encrypted data");
        return encrypted;
    }

    @RequestMapping(value={"decrypt"}, method={RequestMethod.POST})
    public String decrypt(@RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        return this.decrypt(this.defaultApplicationName, this.defaultProfile, data, type);
    }

    @RequestMapping(value={"/decrypt/{name}/{profiles}"}, method={RequestMethod.POST})
    public String decrypt(@PathVariable String name, @PathVariable String profiles, @RequestBody String data, @RequestHeader(value="Content-Type") MediaType type) {
        this.checkEncryptorInstalled(name, profiles);
        try {
            String input = this.stripFormData(this.helper.stripPrefix(data), type, true);
            Map<String, String> encryptorKeys = this.helper.getEncryptorKeys(name, profiles, data);
            TextEncryptor encryptor = this.encryptor.locate(encryptorKeys);
            String decrypted = encryptor.decrypt(input);
            logger.info((Object)"Decrypted cipher data");
            return decrypted;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error((Object)("Cannot decrypt key:" + name + ", value:" + data), (Throwable)e);
            throw new InvalidCipherException();
        }
    }

    private void checkEncryptorInstalled(String name, String profiles) {
        if (this.encryptor == null) {
            throw new KeyNotInstalledException();
        }
        if (this.encryptor.locate(this.helper.getEncryptorKeys(name, profiles, "")).encrypt("FOO").equals("FOO")) {
            throw new EncryptionTooWeakException();
        }
    }

    private String stripFormData(String data, MediaType type, boolean cipher) {
        if (data.endsWith("=") && !type.equals((Object)MediaType.TEXT_PLAIN)) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                if (cipher) {
                    data = data.replace(" ", "+");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String candidate = data.substring(0, data.length() - 1);
            if (cipher) {
                if (data.endsWith("=") && data.length() / 2 != (data.length() + 1) / 2) {
                    try {
                        Hex.decode((CharSequence)candidate);
                        return candidate;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            Base64Utils.decode((byte[])candidate.getBytes());
                            return candidate;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                return data;
            }
            data = candidate;
        }
        return data;
    }

    @ExceptionHandler(value={KeyNotInstalledException.class})
    public ResponseEntity<Map<String, Object>> notInstalled() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "NO_KEY");
        body.put("description", "No key was installed for encryption service");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={EncryptionTooWeakException.class})
    public ResponseEntity<Map<String, Object>> encryptionTooWeak() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "INVALID");
        body.put("description", "The encryption algorithm is not strong enough");
        return new ResponseEntity(body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidCipherException.class})
    public ResponseEntity<Map<String, Object>> invalidCipher() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", "INVALID");
        body.put("description", "Text not encrypted with this key");
        return new ResponseEntity(body, HttpStatus.BAD_REQUEST);
    }
}

