/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.AbstractCipherResourceEncryptor;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.stereotype.Component;

@Component
public class CipherResourcePropertiesEncryptor
extends AbstractCipherResourceEncryptor
implements ResourceEncryptor {
    private static final List<String> SUPPORTED_EXTENSIONS = Arrays.asList("properties");

    public CipherResourcePropertiesEncryptor(TextEncryptorLocator encryptor) {
        super(encryptor);
    }

    @Override
    public List<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public String decrypt(String text, Environment environment) throws IOException {
        HashSet<String> valsToDecrypt = new HashSet<String>();
        Properties properties = new Properties();
        StringBuffer sb = new StringBuffer();
        properties.load(new ByteArrayInputStream(text.getBytes()));
        for (Object object : properties.values()) {
            String valueStr = object.toString();
            if (!valueStr.startsWith("{cipher}")) continue;
            valsToDecrypt.add(valueStr);
        }
        for (String string : valsToDecrypt) {
            String decryptedValue = this.decryptValue(string.replace("{cipher}", ""), environment.getName(), environment.getProfiles());
            text = text.replace(string, decryptedValue);
        }
        return text;
    }
}

