/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulFilesPropertySource;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public class ConsulPropertySources {
    protected static final List<String> DIR_SUFFIXES = Collections.singletonList("/");
    protected static final List<String> FILES_SUFFIXES = Collections.unmodifiableList(Arrays.asList(".yml", ".yaml", ".properties"));
    private final ConsulConfigProperties properties;
    private final Log log;

    public ConsulPropertySources(ConsulConfigProperties properties, Log log) {
        this.properties = properties;
        this.log = log;
    }

    public List<String> getAutomaticContexts(List<String> profiles) {
        return this.getAutomaticContexts(profiles, true);
    }

    public List<String> getAutomaticContexts(List<String> profiles, boolean reverse) {
        return this.generateAutomaticContexts(profiles, reverse).stream().map(Context::getPath).collect(Collectors.toList());
    }

    public List<Context> generateAutomaticContexts(List<String> profiles, boolean reverse) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (String prefix : this.properties.getPrefixes()) {
            String defaultContext = this.getContext(prefix, this.properties.getDefaultContext());
            List<String> suffixes = this.getSuffixes();
            for (String suffix : suffixes) {
                contexts.add(new Context(defaultContext + suffix));
            }
            for (String suffix : suffixes) {
                this.addProfiles(contexts, defaultContext, profiles, suffix);
            }
            String baseContext = this.getContext(prefix, this.properties.getName());
            for (String suffix : suffixes) {
                contexts.add(new Context(baseContext + suffix));
            }
            for (String suffix : suffixes) {
                this.addProfiles(contexts, baseContext, profiles, suffix);
            }
        }
        if (reverse) {
            Collections.reverse(contexts);
        }
        return contexts;
    }

    protected String getContext(String prefix, String context) {
        if (!StringUtils.hasText((String)prefix)) {
            return context;
        }
        return prefix + "/" + context;
    }

    protected List<String> getSuffixes() {
        if (this.properties.getFormat() == ConsulConfigProperties.Format.FILES) {
            return FILES_SUFFIXES;
        }
        return DIR_SUFFIXES;
    }

    private void addProfiles(List<Context> contexts, String baseContext, List<String> profiles, String suffix) {
        for (String profile : profiles) {
            String path = baseContext + this.properties.getProfileSeparator() + profile + suffix;
            contexts.add(new Context(path, profile));
        }
    }

    @Deprecated
    public ConsulPropertySource createPropertySource(String propertySourceContext, boolean optional, ConsulClient consul, BiConsumer<String, Long> indexConsumer) {
        return this.createPropertySource(propertySourceContext, consul, indexConsumer);
    }

    public ConsulPropertySource createPropertySource(String propertySourceContext, ConsulClient consul, BiConsumer<String, Long> indexConsumer) {
        try {
            ConsulPropertySource propertySource = null;
            if (this.properties.getFormat() == ConsulConfigProperties.Format.FILES) {
                Response response = consul.getKVValue(propertySourceContext, this.properties.getAclToken());
                indexConsumer.accept(propertySourceContext, response.getConsulIndex());
                if (response.getValue() != null) {
                    ConsulFilesPropertySource filesPropertySource = new ConsulFilesPropertySource(propertySourceContext, consul, this.properties);
                    filesPropertySource.init((GetValue)response.getValue());
                    propertySource = filesPropertySource;
                }
            } else {
                propertySource = this.create(propertySourceContext, consul, indexConsumer);
            }
            return propertySource;
        }
        catch (PropertySourceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.properties.isFailFast()) {
                throw new PropertySourceNotFoundException(propertySourceContext, e);
            }
            this.log.warn((Object)("Unable to load consul config from " + propertySourceContext), (Throwable)e);
            return null;
        }
    }

    private ConsulPropertySource create(String context, ConsulClient consulClient, BiConsumer<String, Long> indexConsumer) {
        ConsulPropertySource propertySource = new ConsulPropertySource(context, consulClient, this.properties);
        propertySource.init();
        indexConsumer.accept(context, propertySource.getInitialIndex());
        return propertySource;
    }

    static class PropertySourceNotFoundException
    extends RuntimeException {
        private final String context;

        PropertySourceNotFoundException(String context) {
            this.context = context;
        }

        PropertySourceNotFoundException(String context, Exception cause) {
            super(cause);
            this.context = context;
        }

        public String getContext() {
            return this.context;
        }
    }

    public static class Context {
        private final String path;
        private final String profile;

        public Context(String path) {
            this.path = path;
            this.profile = null;
        }

        public Context(String path, String profile) {
            this.path = path;
            this.profile = profile;
        }

        public String getPath() {
            return this.path;
        }

        public String getProfile() {
            return this.profile;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("path", (Object)this.path).append("profile", (Object)this.profile).toString();
        }
    }
}

