/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import com.ecwid.consul.v1.health.model.Check;
import java.util.Optional;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.serviceregistry.ApplicationStatusProvider;

public class ActuatorHealthApplicationStatusProvider
implements ApplicationStatusProvider {
    private HealthEndpoint healthEndpoint;
    private HeartbeatProperties heartbeatProperties;

    public ActuatorHealthApplicationStatusProvider(HealthEndpoint healthEndpoint, HeartbeatProperties heartbeatProperties) {
        this.healthEndpoint = healthEndpoint;
        this.heartbeatProperties = heartbeatProperties;
    }

    @Override
    public Check.CheckStatus currentStatus() {
        String[] stringArray;
        String healthGroup = this.heartbeatProperties.getActuatorHealthGroup();
        if (healthGroup == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = healthGroup;
        }
        String[] path = stringArray;
        return Optional.ofNullable(this.healthEndpoint.healthForPath(path)).map(HealthComponent::getStatus).map(this::healthStatusToCheckStatus).orElse(Check.CheckStatus.UNKNOWN);
    }

    private Check.CheckStatus healthStatusToCheckStatus(Status healthStatus) {
        if (healthStatus == Status.UP) {
            return Check.CheckStatus.PASSING;
        }
        if (healthStatus == Status.DOWN || healthStatus == Status.OUT_OF_SERVICE) {
            return Check.CheckStatus.CRITICAL;
        }
        return Check.CheckStatus.UNKNOWN;
    }
}

