/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.health.model.HealthService;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;
import org.springframework.core.style.ToStringCreator;

public class ConsulServiceInstance
extends DefaultServiceInstance {
    private HealthService healthService;

    public ConsulServiceInstance(HealthService healthService, String serviceId) {
        this(healthService.getService().getId(), serviceId, ConsulServerUtils.findHost(healthService), ConsulServiceInstance.getPort(healthService.getService()), ConsulServiceInstance.getSecure(healthService), ConsulServiceInstance.getMetadata(healthService), healthService.getService().getTags());
        this.healthService = healthService;
    }

    public ConsulServiceInstance(String instanceId, String serviceId, String host, int port, boolean secure, Map<String, String> metadata, List<String> tags) {
        super(instanceId, serviceId, host, port, secure, metadata);
    }

    public ConsulServiceInstance(String instanceId, String serviceId, String host, int port, boolean secure) {
        super(instanceId, serviceId, host, port, secure);
    }

    public ConsulServiceInstance() {
    }

    private static Map<String, String> getMetadata(HealthService healthService) {
        LinkedHashMap metadata = healthService.getService().getMeta();
        if (metadata == null) {
            metadata = new LinkedHashMap();
        }
        return metadata;
    }

    private static int getPort(HealthService.Service service) {
        Integer port = service.getPort();
        if (port == null) {
            return 0;
        }
        return port;
    }

    private static boolean getSecure(HealthService healthService) {
        boolean secure = false;
        Map<String, String> metadata = ConsulServiceInstance.getMetadata(healthService);
        if (metadata.containsKey("secure")) {
            secure = Boolean.parseBoolean(metadata.get("secure"));
        }
        return secure;
    }

    public HealthService getHealthService() {
        return this.healthService;
    }

    public void setHealthService(HealthService healthService) {
        this.healthService = healthService;
    }

    public List<String> getTags() {
        if (this.healthService != null) {
            return this.healthService.getService().getTags();
        }
        return Collections.emptyList();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("instanceId", (Object)this.getInstanceId()).append("serviceId", (Object)this.getServiceId()).append("host", (Object)this.getHost()).append("port", this.getPort()).append("secure", this.isSecure()).append("metadata", (Object)this.getMetadata()).append("uri", (Object)this.getUri()).append("healthService", (Object)this.healthService).toString();
    }
}

