/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.context.environment.EnvironmentManagerMvcEndpoint;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.context.restart.RestartMvcEndpoint;
import org.springframework.cloud.endpoint.GenericPostableMvcEndpoint;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={EnvironmentEndpoint.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, RefreshEndpointAutoConfiguration.class})
public class LifecycleMvcEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={EnvironmentEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="env.post")
    public EnvironmentManagerMvcEndpoint environmentManagerEndpoint(EnvironmentEndpoint delegate, EnvironmentManager environment) {
        return new EnvironmentManagerMvcEndpoint(delegate, environment);
    }

    @Bean
    @ConditionalOnBean(value={RefreshEndpoint.class})
    public MvcEndpoint refreshMvcEndpoint(RefreshEndpoint endpoint) {
        return new GenericPostableMvcEndpoint((Endpoint<?>)endpoint);
    }

    @Bean
    @ConditionalOnBean(value={RestartEndpoint.class})
    public RestartMvcEndpoint restartMvcEndpoint(RestartEndpoint restartEndpoint) {
        return new RestartMvcEndpoint(restartEndpoint);
    }

    @Bean
    @ConditionalOnBean(value={RestartEndpoint.PauseEndpoint.class})
    public MvcEndpoint pauseMvcEndpoint(RestartEndpoint.PauseEndpoint pauseEndpoint) {
        return new GenericPostableMvcEndpoint((Endpoint<?>)pauseEndpoint);
    }

    @Bean
    @ConditionalOnBean(value={RestartEndpoint.ResumeEndpoint.class})
    public MvcEndpoint resumeMvcEndpoint(RestartEndpoint.ResumeEndpoint resumeEndpoint) {
        return new GenericPostableMvcEndpoint((Endpoint<?>)resumeEndpoint);
    }
}

