/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.springframework.cloud.contract.stubrunner.ContractDownloader;
import org.springframework.cloud.contract.stubrunner.ScmStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerPropertyUtils;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@CacheableTask
class ContractsCopyTask
extends DefaultTask {
    static final String TASK_NAME = "copyContracts";
    static final String CONTRACTS = "contracts";
    static final String BACKUP = "original";
    private final Property<Boolean> convertToYaml;
    private final Property<Boolean> failOnNoContracts;
    private final DirectoryProperty contractsDirectory;
    private final Dependency contractDependency;
    private final Repository contractRepository;
    private final Property<StubRunnerProperties.StubsMode> contractsMode;
    private final MapProperty<String, String> contractsProperties;
    private final Provider<Map<String, String>> allContractsProperties;
    private final Property<String> contractsPath;
    private final Property<Boolean> excludeBuildFolders;
    private final Property<Boolean> deleteStubsAfterTest;
    private final ConfigurableFileCollection classpath;
    private final DirectoryProperty copiedContractsFolder;
    private final DirectoryProperty backupContractsFolder;
    private final Property<String> projectGroup;
    private final Property<String> projectName;
    private final Property<String> projectVersion;
    private final ExecOperations executors;
    private final FileSystemOperations files;

    @Inject
    public ContractsCopyTask(ObjectFactory objects, ProviderFactory providers, ExecOperations executors, FileSystemOperations files) {
        this.executors = executors;
        this.files = files;
        this.convertToYaml = objects.property(Boolean.class);
        this.failOnNoContracts = objects.property(Boolean.class);
        this.contractsDirectory = objects.directoryProperty();
        this.contractDependency = (Dependency)objects.newInstance(Dependency.class, new Object[0]);
        this.contractRepository = (Repository)objects.newInstance(Repository.class, new Object[0]);
        this.contractsMode = objects.property(StubRunnerProperties.StubsMode.class);
        this.contractsProperties = objects.mapProperty(String.class, String.class);
        this.allContractsProperties = this.contractsProperties.flatMap(contractsProps -> {
            MapProperty allProps = objects.mapProperty(String.class, String.class);
            allProps.putAll(contractsProps);
            String gitCommitId = this.discoverGitCommitId((Map<String, String>)contractsProps);
            if (StringUtils.hasText((String)gitCommitId)) {
                allProps.put((Object)"git.commit", (Object)gitCommitId);
            }
            return allProps;
        });
        this.contractsPath = objects.property(String.class);
        this.excludeBuildFolders = objects.property(Boolean.class);
        this.deleteStubsAfterTest = objects.property(Boolean.class);
        this.classpath = objects.fileCollection();
        this.copiedContractsFolder = objects.directoryProperty();
        this.backupContractsFolder = objects.directoryProperty();
        this.projectGroup = objects.property(String.class).convention(providers.provider(() -> this.getProject().getGroup().toString()));
        this.projectName = objects.property(String.class).convention(providers.provider(() -> this.getProject().getName()));
        this.projectVersion = objects.property(String.class).convention(providers.provider(() -> this.getProject().getVersion().toString()));
        this.getOutputs().upToDateWhen(task -> !this.shouldDownloadContracts() || !this.getContractDependency().toStubConfiguration().isVersionChanging());
    }

    @TaskAction
    void sync() {
        Object antPattern;
        File contractsDirectory;
        if (this.shouldDownloadContracts()) {
            DownloadedData downloadedData = this.downloadContracts();
            contractsDirectory = downloadedData.downloadedContracts;
            antPattern = downloadedData.inclusionProperties.getIncludedRootFolderAntPattern() + "*.*";
            this.getLogger().info("Contracts got downloaded to [{}]", (Object)contractsDirectory);
        } else {
            contractsDirectory = (File)this.contractsDirectory.getAsFile().getOrNull();
            antPattern = "**/";
        }
        this.getLogger().info("For project [{}] will use contracts provided in the folder [{}]", this.projectName.get(), (Object)contractsDirectory);
        String contractsRepository = (String)this.contractRepository.getRepositoryUrl().getOrElse((Object)"");
        this.throwExceptionWhenFailOnNoContracts(contractsDirectory, contractsRepository);
        String slashSeparatedGroupId = ((String)this.projectGroup.get()).replace(".", File.separator);
        String dotSeparatedAntPattern = ((String)antPattern).replace(slashSeparatedGroupId, (CharSequence)this.projectGroup.get());
        File output = ((Directory)this.copiedContractsFolder.get()).getAsFile();
        this.getLogger().info("Downloading and unpacking files from [{}] to [{}]. The inclusion ant patterns are [{}] and [{}]", new Object[]{contractsDirectory, output, antPattern, dotSeparatedAntPattern});
        this.sync(contractsDirectory, (String)antPattern, dotSeparatedAntPattern, (Boolean)this.excludeBuildFolders.get(), output);
        if (((Boolean)this.convertToYaml.get()).booleanValue()) {
            this.convertContractsToYaml(contractsDirectory, (String)antPattern, dotSeparatedAntPattern, output, (Boolean)this.excludeBuildFolders.get());
        }
    }

    private void convertContractsToYaml(File file, String antPattern, String slashSeparatedAntPattern, File outputContractsFolder, boolean excludeBuildFolders) {
        this.sync(file, antPattern, slashSeparatedAntPattern, excludeBuildFolders, ((Directory)this.backupContractsFolder.get()).getAsFile());
        ByteArrayOutputStream os = this.getLogger().isDebugEnabled() ? new ByteArrayOutputStream() : NullOutputStream.INSTANCE;
        try {
            this.executors.javaexec(exec -> {
                exec.getMainClass().set((Object)"org.springframework.cloud.contract.verifier.converter.ToYamlConverterApplication");
                exec.classpath(new Object[]{this.classpath});
                exec.args(new Object[]{this.quoteAndEscape(outputContractsFolder.getAbsolutePath())});
                exec.setStandardOutput(os);
                exec.setErrorOutput(os);
            });
        }
        catch (Exception e) {
            throw new GradleException("Spring Cloud Contract Verifier Plugin exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(((Object)os).toString());
            }
        }
        this.getLogger().info("Replaced DSL files with their YAML representation at [{}]", (Object)outputContractsFolder);
    }

    private void sync(File file, String antPattern, String dotSeparatedAntPattern, boolean excludeBuildFolders, File outputContractsFolder) {
        this.files.sync(spec -> {
            spec.from(new Object[]{file});
            spec.include(new String[]{antPattern});
            spec.include(new String[]{dotSeparatedAntPattern});
            if (excludeBuildFolders) {
                spec.exclude(new String[]{"**/target/**", "**/build/**", "**/.mvn/**", "**/.gradle/**"});
            }
            spec.into((Object)outputContractsFolder);
        });
    }

    private DownloadedData downloadContracts() {
        String groupId = (String)this.projectGroup.get();
        String artifactId = (String)this.projectName.get();
        this.getLogger().info("Project has group id [{}], artifact id [{}]", (Object)groupId, (Object)artifactId);
        this.getLogger().info("For project [{}] Download dependency is provided - will download contract jars", (Object)artifactId);
        this.getLogger().info("Contract dependency [{}]", (Object)this.contractDependency);
        StubConfiguration configuration = this.contractDependency.toStubConfiguration();
        this.getLogger().info("Got the following contract dependency to download [{}]", (Object)configuration);
        this.getLogger().info("The contract dependency is a changing one [{}]", (Object)configuration.isVersionChanging());
        StubDownloader downloader = new StubDownloaderBuilderProvider().get(this.createStubRunnerOptions(), new StubDownloaderBuilder[0]);
        ContractDownloader contractDownloader = new ContractDownloader(downloader, configuration, (String)this.contractsPath.getOrNull(), groupId, artifactId, (String)this.projectVersion.get());
        File downloadedContracts = contractDownloader.unpackAndDownloadContracts();
        ContractDownloader.InclusionProperties inclusionProperties = contractDownloader.createNewInclusionProperties(downloadedContracts);
        return new DownloadedData(this.contractsSubDirIfPresent(downloadedContracts), inclusionProperties);
    }

    private void throwExceptionWhenFailOnNoContracts(@Nullable File file, String contractsRepository) {
        if (StringUtils.hasText((String)contractsRepository)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Contracts repository is set, will not throw an exception that the contracts are not found");
            }
            return;
        }
        if (((Boolean)this.failOnNoContracts.get()).booleanValue() && (file == null || !file.exists() || file.listFiles().length == 0)) {
            String path = file != null ? file.getAbsolutePath() : "";
            throw new GradleException("Contracts could not be found: [" + path + "]\nPlease make sure that the contracts were defined, or set the [failOnNoContracts] flag to [false]");
        }
    }

    private File contractsSubDirIfPresent(File contractsDirectory) {
        File contracts = new File(contractsDirectory, CONTRACTS);
        if (contracts.exists()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Contracts folder found [{}]", (Object)contracts);
            }
            contractsDirectory = contracts;
        }
        return contractsDirectory;
    }

    @Input
    protected Property<String> getProjectGroup() {
        return this.projectGroup;
    }

    @Input
    protected Property<String> getProjectName() {
        return this.projectName;
    }

    @Input
    protected Property<String> getProjectVersion() {
        return this.projectVersion;
    }

    @Input
    Property<Boolean> getConvertToYaml() {
        return this.convertToYaml;
    }

    @Input
    Property<Boolean> getFailOnNoContracts() {
        return this.failOnNoContracts;
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    DirectoryProperty getContractsDirectory() {
        return this.contractsDirectory;
    }

    @Nested
    Dependency getContractDependency() {
        return this.contractDependency;
    }

    @Nested
    Repository getContractRepository() {
        return this.contractRepository;
    }

    @Input
    @Optional
    Property<StubRunnerProperties.StubsMode> getContractsMode() {
        return this.contractsMode;
    }

    @Internal
    MapProperty<String, String> getContractsProperties() {
        return this.contractsProperties;
    }

    @Input
    Provider<Map<String, String>> getAllContractsProperties() {
        return this.allContractsProperties;
    }

    @Input
    @Optional
    Property<String> getContractsPath() {
        return this.contractsPath;
    }

    @Input
    Property<Boolean> getExcludeBuildFolders() {
        return this.excludeBuildFolders;
    }

    @Input
    Property<Boolean> getDeleteStubsAfterTest() {
        return this.deleteStubsAfterTest;
    }

    @Classpath
    ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputDirectory
    DirectoryProperty getCopiedContractsFolder() {
        return this.copiedContractsFolder;
    }

    @Optional
    @OutputDirectory
    DirectoryProperty getBackupContractsFolder() {
        return this.backupContractsFolder;
    }

    private boolean shouldDownloadContracts() {
        return StringUtils.hasText((String)((String)this.contractDependency.getArtifactId().getOrNull())) || StringUtils.hasText((String)((String)this.contractDependency.getStringNotation().getOrNull())) || StringUtils.hasText((String)((String)this.contractRepository.getRepositoryUrl().getOrNull()));
    }

    private StubRunnerOptions createStubRunnerOptions() {
        StubRunnerOptionsBuilder options = new StubRunnerOptionsBuilder().withOptions(StubRunnerOptions.fromSystemProps()).withStubRepositoryRoot((String)this.contractRepository.repositoryUrl.getOrNull()).withStubsMode((StubRunnerProperties.StubsMode)this.contractsMode.get()).withUsername((String)this.contractRepository.username.getOrNull()).withPassword((String)this.contractRepository.password.getOrNull()).withDeleteStubsAfterTest(((Boolean)this.deleteStubsAfterTest.get()).booleanValue()).withProperties((Map)this.allContractsProperties.getOrNull()).withFailOnNoStubs(((Boolean)this.failOnNoContracts.get()).booleanValue());
        if (this.contractRepository.proxyPort.isPresent()) {
            options = options.withProxy((String)this.contractRepository.proxyHost.getOrNull(), ((Integer)this.contractRepository.proxyPort.get()).intValue());
        }
        return options.build();
    }

    @Nullable
    private String discoverGitCommitId(Map<String, String> props) {
        String repositoryUrl = (String)this.contractRepository.getRepositoryUrl().getOrNull();
        if (repositoryUrl != null && ScmStubDownloaderBuilder.isProtocolAccepted((String)repositoryUrl)) {
            String branch = StubRunnerPropertyUtils.getProperty(props, (String)"git.branch");
            branch = StringUtils.hasText((String)branch) ? branch : "master";
            UsernamePasswordCredentialsProvider provider = null;
            if (StringUtils.hasText((String)((String)this.contractRepository.getUsername().getOrNull()))) {
                provider = new UsernamePasswordCredentialsProvider((String)this.contractRepository.getUsername().get(), (String)this.contractRepository.getPassword().get());
            }
            try {
                URI repoUri = URI.create(repositoryUrl);
                String part = repoUri.getSchemeSpecificPart();
                String repoUrl = !StringUtils.hasLength((String)part) ? part : (part.startsWith("//") ? part.substring(2) : part);
                Collection refs = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(repoUrl).setCredentialsProvider((CredentialsProvider)provider)).call();
                for (Ref ref : refs) {
                    if (!ref.getName().equals(branch) && !ref.getName().equals("refs/heads/" + branch) && !ref.getName().equals("refs/tags/" + branch)) continue;
                    return ref.getObjectId().name();
                }
            }
            catch (GitAPIException e) {
                this.getLogger().warn("Unable to determine git repository commit id", (Throwable)e);
            }
        }
        return null;
    }

    private String quoteAndEscape(String str) {
        if (System.getProperty("os.name").contains("Windows")) {
            return "\"" + str.replace("\"", "\\\"") + "\"";
        }
        return str;
    }

    static class Dependency {
        private static final String LATEST_VERSION = "+";
        private final Property<String> groupId;
        private final Property<String> artifactId;
        private final Property<String> version;
        private final Property<String> classifier;
        private final Property<String> stringNotation;

        @Inject
        public Dependency(ObjectFactory objects) {
            this.groupId = objects.property(String.class);
            this.artifactId = objects.property(String.class);
            this.version = objects.property(String.class);
            this.classifier = objects.property(String.class);
            this.stringNotation = objects.property(String.class);
        }

        @Input
        @Optional
        Property<String> getGroupId() {
            return this.groupId;
        }

        @Input
        @Optional
        Property<String> getArtifactId() {
            return this.artifactId;
        }

        @Input
        @Optional
        Property<String> getVersion() {
            return this.version;
        }

        @Input
        @Optional
        Property<String> getClassifier() {
            return this.classifier;
        }

        @Input
        @Optional
        Property<String> getStringNotation() {
            return this.stringNotation;
        }

        StubConfiguration toStubConfiguration() {
            String stringNotation = (String)this.stringNotation.getOrNull();
            if (StringUtils.hasText((String)stringNotation)) {
                return new StubConfiguration(stringNotation);
            }
            String groupId = (String)this.groupId.getOrNull();
            String artifactId = (String)this.artifactId.getOrNull();
            String version = StringUtils.hasText((String)((String)this.version.getOrNull())) ? (String)this.version.getOrNull() : LATEST_VERSION;
            String classifier = (String)this.classifier.getOrNull();
            return new StubConfiguration(groupId, artifactId, version, classifier);
        }
    }

    static class Repository {
        private final Property<String> repositoryUrl;
        private final Property<String> username;
        private final Property<String> password;
        private final Property<String> proxyHost;
        private final Property<Integer> proxyPort;

        @Inject
        public Repository(ObjectFactory objects) {
            this.repositoryUrl = objects.property(String.class);
            this.username = objects.property(String.class);
            this.password = objects.property(String.class);
            this.proxyHost = objects.property(String.class);
            this.proxyPort = objects.property(Integer.class);
        }

        @Input
        @Optional
        Property<String> getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Input
        @Optional
        Property<String> getUsername() {
            return this.username;
        }

        @Input
        @Optional
        Property<String> getPassword() {
            return this.password;
        }

        @Input
        @Optional
        Property<String> getProxyHost() {
            return this.proxyHost;
        }

        @Input
        @Optional
        Property<Integer> getProxyPort() {
            return this.proxyPort;
        }
    }

    private class DownloadedData {
        final File downloadedContracts;
        final ContractDownloader.InclusionProperties inclusionProperties;

        private DownloadedData(File downloadedContracts, ContractDownloader.InclusionProperties inclusionProperties) {
            this.downloadedContracts = downloadedContracts;
            this.inclusionProperties = inclusionProperties;
        }
    }
}

