// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.1.2,
// any modifications will be overwritten.
// ==============================================================

package shaded.shaded.org.apache.maven.artifact.repository.metadata;

/**
 * Class Metadata.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Metadata
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The version of the underlying metadata model.
     */
    private String modelVersion;

    /**
     * The groupId when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     */
    private String groupId;

    /**
     * The artifactId when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     */
    private String artifactId;

    /**
     * Versioning information when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     */
    private Versioning versioning;

    /**
     * The base version (ie. ending in <code>-SNAPSHOT</code>) when
     * this directory represents a "groupId/artifactId/version" for
     * a SNAPSHOT.
     */
    private String version;

    /**
     * Field plugins.
     */
    @Deprecated
    private java.util.List<Plugin> plugins;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin.
     * 
     * @param plugin a plugin object.
     */
    public void addPlugin( Plugin plugin )
    {
        getPlugins().add( plugin );
    } //-- void addPlugin( Plugin )

    /**
     * Method clone.
     * 
     * @return Metadata
     */
    public Metadata clone()
    {
        try
        {
            Metadata copy = (Metadata) super.clone();

            if ( this.versioning != null )
            {
                copy.versioning = (Versioning) this.versioning.clone();
            }

            if ( this.plugins != null )
            {
                copy.plugins = new java.util.ArrayList<Plugin>();
                for ( Plugin item : this.plugins )
                {
                    copy.plugins.add( ( (Plugin) item).clone() );
                }
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Metadata clone()

    /**
     * Get the artifactId when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get the groupId when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get the version of the underlying metadata model.
     * 
     * @return String
     */
    public String getModelVersion()
    {
        return this.modelVersion;
    } //-- String getModelVersion()

    /**
     * Method getPlugins.
     * 
     * @return List
     */
    public java.util.List<Plugin> getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList<Plugin>();
        }

        return this.plugins;
    } //-- java.util.List<Plugin> getPlugins()

    /**
     * Get the base version (ie. ending in <code>-SNAPSHOT</code>)
     * when this directory represents a
     * "groupId/artifactId/version" for a SNAPSHOT.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get versioning information when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     * 
     * @return Versioning
     */
    public Versioning getVersioning()
    {
        return this.versioning;
    } //-- Versioning getVersioning()

    /**
     * Method removePlugin.
     * 
     * @param plugin a plugin object.
     */
    public void removePlugin( Plugin plugin )
    {
        getPlugins().remove( plugin );
    } //-- void removePlugin( Plugin )

    /**
     * Set the artifactId when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     * 
     * @param artifactId a artifactId object.
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set the groupId when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     * 
     * @param groupId a groupId object.
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding a modelEncoding object.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the version of the underlying metadata model.
     * 
     * @param modelVersion a modelVersion object.
     */
    public void setModelVersion( String modelVersion )
    {
        this.modelVersion = modelVersion;
    } //-- void setModelVersion( String )

    /**
     * Set the set of plugins when this directory represents a
     * "groupId" (deprecated).
     * 
     * @param plugins a plugins object.
     */
    public void setPlugins( java.util.List<Plugin> plugins )
    {
        this.plugins = plugins;
    } //-- void setPlugins( java.util.List )

    /**
     * Set the base version (ie. ending in <code>-SNAPSHOT</code>)
     * when this directory represents a
     * "groupId/artifactId/version" for a SNAPSHOT.
     * 
     * @param version a version object.
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Set versioning information when this directory represents
     * "groupId/artifactId" or "groupId/artifactId/version".
     * 
     * @param versioning a versioning object.
     */
    public void setVersioning( Versioning versioning )
    {
        this.versioning = versioning;
    } //-- void setVersioning( Versioning )

    
    private String getSnapshotVersionKey( SnapshotVersion sv )
    {
        return sv.getClassifier() + ":" + sv.getExtension();
    }

    public boolean merge( Metadata sourceMetadata )
    {
        boolean changed = false;

        for ( Plugin plugin : sourceMetadata.getPlugins() )
        {
            boolean found = false;

            for ( Plugin preExisting : getPlugins() )
            {
                if ( preExisting.getPrefix().equals( plugin.getPrefix() ) )
                {
                    found = true;
                    break;
                }
            }

            if ( !found )
            {
                Plugin mappedPlugin = new Plugin();

                mappedPlugin.setArtifactId( plugin.getArtifactId() );

                mappedPlugin.setPrefix( plugin.getPrefix() );

                mappedPlugin.setName( plugin.getName() );

                addPlugin( mappedPlugin );

                changed = true;
            }
        }

        Versioning versioning = sourceMetadata.getVersioning();
        if ( versioning != null )
        {
            Versioning v = getVersioning();
            if ( v == null )
            {
                v = new Versioning();
                setVersioning( v );
                changed = true;
            }

            for ( String version : versioning.getVersions() )
            {
                if ( !v.getVersions().contains( version ) )
                {
                    changed = true;
                    v.getVersions().add( version );
                }
            }

            if ( "null".equals( versioning.getLastUpdated() ) )
            {
                versioning.setLastUpdated( null );
            }

            if ( "null".equals( v.getLastUpdated() ) )
            {
                v.setLastUpdated( null );
            }

            if ( versioning.getLastUpdated() == null || versioning.getLastUpdated().length() == 0 )
            {
                // this should only be for historical reasons - we assume local is newer
                versioning.setLastUpdated( v.getLastUpdated() );
            }

            if ( v.getLastUpdated() == null || v.getLastUpdated().length() == 0
                 || versioning.getLastUpdated().compareTo( v.getLastUpdated() ) >= 0 )
            {
                changed = true;
                v.setLastUpdated( versioning.getLastUpdated() );

                if ( versioning.getRelease() != null )
                {
                    changed = true;
                    v.setRelease( versioning.getRelease() );
                }
                if ( versioning.getLatest() != null )
                {
                    changed = true;
                    v.setLatest( versioning.getLatest() );
                }

                Snapshot s = v.getSnapshot();
                Snapshot snapshot = versioning.getSnapshot();
                if ( snapshot != null )
                {
                    boolean updateSnapshotVersions = false;
                    if ( s == null )
                    {
                        s = new Snapshot();
                        v.setSnapshot( s );
                        changed = true;
                        updateSnapshotVersions = true;
                    }

                    // overwrite
                    if ( s.getTimestamp() == null ? snapshot.getTimestamp() != null
                        : !s.getTimestamp().equals( snapshot.getTimestamp() ) )
                    {
                        s.setTimestamp( snapshot.getTimestamp() );
                        changed = true;
                        updateSnapshotVersions = true;
                    }
                    if ( s.getBuildNumber() != snapshot.getBuildNumber() )
                    {
                        s.setBuildNumber( snapshot.getBuildNumber() );
                        changed = true;
                    }
                    if ( s.isLocalCopy() != snapshot.isLocalCopy() )
                    {
                        s.setLocalCopy( snapshot.isLocalCopy() );
                        changed = true;
                    }
                    if ( updateSnapshotVersions )
                    {
                        java.util.Map<String, SnapshotVersion> versions = new java.util.LinkedHashMap<>();
                        // never convert from legacy to new format if either source or target is legacy format
                        if ( !v.getSnapshotVersions().isEmpty() )
                        {
                            for ( SnapshotVersion sv : versioning.getSnapshotVersions() )
                            {
                                String key = getSnapshotVersionKey( sv );
                                versions.put( key, sv );
                            }
                            // never convert from legacy format
                            if ( !versions.isEmpty() )
                            {
                                for ( SnapshotVersion sv : v.getSnapshotVersions() )
                                {
                                    String key = getSnapshotVersionKey( sv );
                                    if ( !versions.containsKey( key ) )
                                    {
                                        versions.put( key, sv );
                                    }
                                }
                            }
                            v.setSnapshotVersions( new java.util.ArrayList<SnapshotVersion>( versions.values() ) );
                        }

                        changed = true;
                    }
                }
            }
        }
        return changed;
    }
          
}
