/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunner;
import org.springframework.cloud.contract.stubrunner.StubRunning;

public class BatchStubRunner
implements StubRunning {
    private final Iterable<StubRunner> stubRunners;

    public BatchStubRunner(Iterable<StubRunner> stubRunners) {
        this.stubRunners = stubRunners;
    }

    @Override
    public RunningStubs runStubs() {
        LinkedHashMap<StubConfiguration, Integer> map = new LinkedHashMap<StubConfiguration, Integer>();
        for (StubRunner value : this.stubRunners) {
            RunningStubs runningStubs = value.runStubs();
            map.putAll(runningStubs.validNamesAndPorts());
        }
        return new RunningStubs(map);
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        for (StubRunner stubRunner : this.stubRunners) {
            URL url = stubRunner.findStubUrl(groupId, artifactId);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        String[] splitString = ivyNotation.split(":");
        if (splitString.length > 3) {
            throw new IllegalArgumentException(ivyNotation + " is invalid");
        }
        if (splitString.length == 2) {
            return this.findStubUrl(splitString[0], splitString[1]);
        }
        return this.findStubUrl(null, splitString[0]);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        LinkedHashSet<RunningStubs> running = new LinkedHashSet<RunningStubs>();
        for (StubRunner stubRunner : this.stubRunners) {
            running.add(stubRunner.findAllRunningStubs());
        }
        return new RunningStubs(running);
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        LinkedHashMap<StubConfiguration, Collection<Contract>> map = new LinkedHashMap<StubConfiguration, Collection<Contract>>();
        for (StubRunner stubRunner : this.stubRunners) {
            for (Map.Entry<StubConfiguration, Collection<Contract>> entry : stubRunner.getContracts().entrySet()) {
                if (map.containsKey(entry.getKey())) {
                    ((Collection)map.get(entry.getKey())).addAll(entry.getValue());
                    continue;
                }
                map.put(entry.getKey(), new LinkedHashSet<Contract>(entry.getValue()));
            }
        }
        return map;
    }

    @Override
    public boolean trigger(String ivyNotation, String labelName) {
        boolean success = false;
        for (StubRunner stubRunner : this.stubRunners) {
            if (!stubRunner.trigger(ivyNotation, labelName)) continue;
            success = true;
        }
        if (!success) {
            throw new IllegalArgumentException("No label with name [" + labelName + "] for " + "dependency [" + ivyNotation + "] was found. Here you have the list of dependencies " + "and their labels [" + this.ivyToLabels() + "]");
        }
        return success;
    }

    private String ivyToLabels() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Collection<String>> entry : this.labels().entrySet()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Dependency [").append(entry.getKey()).append("] has labels ").append(entry.getValue());
        }
        return builder.toString();
    }

    @Override
    public boolean trigger(String labelName) {
        boolean success = false;
        for (StubRunner stubRunner : this.stubRunners) {
            if (!stubRunner.trigger(labelName)) continue;
            success = true;
        }
        if (!success) {
            throw new IllegalArgumentException("No label with name [" + labelName + "] was found. " + "Here you have the list of dependencies and their labels [" + this.ivyToLabels() + "]");
        }
        return success;
    }

    @Override
    public boolean trigger() {
        boolean success = false;
        for (StubRunner stubRunner : this.stubRunners) {
            if (!stubRunner.trigger()) continue;
            success = true;
        }
        return success;
    }

    @Override
    public Map<String, Collection<String>> labels() {
        LinkedHashMap<String, Collection<String>> map = new LinkedHashMap<String, Collection<String>>();
        for (StubRunner stubRunner : this.stubRunners) {
            for (Map.Entry<String, Collection<String>> entry : stubRunner.labels().entrySet()) {
                if (map.containsKey(entry.getKey())) {
                    ((Collection)map.get(entry.getKey())).addAll(entry.getValue());
                    continue;
                }
                map.put(entry.getKey(), new LinkedHashSet<String>(entry.getValue()));
            }
        }
        return map;
    }

    @Override
    public void close() throws IOException {
        for (StubRunner stubRunner : this.stubRunners) {
            stubRunner.close();
        }
    }
}

