/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.util.ClassUtils;

class WireMockHttpServerStub
implements HttpServerStub {
    private final WireMockServer wireMockServer;

    WireMockHttpServerStub(int port) {
        this.wireMockServer = new WireMockServer((Options)this.config().port(port));
    }

    private WireMockConfiguration config() {
        if (ClassUtils.isPresent((String)"org.springframework.cloud.contract.wiremock.WireMockSpring", null)) {
            return WireMockSpring.options();
        }
        return new WireMockConfiguration();
    }

    @Override
    public int port() {
        return this.wireMockServer.port();
    }

    @Override
    public boolean isRunning() {
        return this.wireMockServer.isRunning();
    }

    @Override
    public void start() {
        this.wireMockServer.start();
    }

    @Override
    public void stop() {
        this.wireMockServer.stop();
    }
}

