/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.stubrunner.Arguments;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;

public class StubRunnerMain {
    private static final Logger log = LoggerFactory.getLogger(StubRunnerMain.class);
    private final Arguments arguments;

    private StubRunnerMain(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        try {
            ArgumentAcceptingOptionSpec minPortValueOpt = parser.acceptsAll(Arrays.asList("minp", "minPort"), "Minimum port value to be assigned to the WireMock instance. Defaults to 10000").withRequiredArg().ofType(Integer.class).defaultsTo((Object)10000, (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec maxPortValueOpt = parser.acceptsAll(Arrays.asList("maxp", "maxPort"), "Maximum port value to be assigned to the WireMock instance. Defaults to 15000").withRequiredArg().ofType(Integer.class).defaultsTo((Object)15000, (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec stubsOpt = parser.acceptsAll(Arrays.asList("s", "stubs"), "Comma separated list of Ivy representation of jars with stubs. Eg. groupid:artifactid1,groupid2:artifactid2:classifier").withRequiredArg();
            ArgumentAcceptingOptionSpec classifierOpt = parser.acceptsAll(Arrays.asList("c", "classifier"), "Suffix for the jar containing stubs (e.g. 'stubs' if the stub jar would have a 'stubs' classifier for stubs: foobar-stubs ). Defaults to 'stubs'").withRequiredArg().defaultsTo((Object)"stubs", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec rootOpt = parser.acceptsAll(Arrays.asList("r", "root"), "Location of a Jar containing server where you keep your stubs (e.g. http://nexus.net/content/repositories/repository)").withRequiredArg();
            ArgumentAcceptingOptionSpec usernameOpt = parser.acceptsAll(Arrays.asList("u", "username"), "Username to user when connecting to repository").withOptionalArg();
            ArgumentAcceptingOptionSpec passwordOpt = parser.acceptsAll(Arrays.asList("p", "password"), "Password to user when connecting to repository").withOptionalArg();
            ArgumentAcceptingOptionSpec proxyHostOpt = parser.acceptsAll(Arrays.asList("phost", "proxyHost"), "Proxy host to use for repository requests").withOptionalArg();
            ArgumentAcceptingOptionSpec proxyPortOpt = parser.acceptsAll(Arrays.asList("pport", "proxyPort"), "Proxy port to use for repository requests").withOptionalArg().ofType(Integer.class);
            parser.acceptsAll(Arrays.asList("wo", "workOffline"), "Switch to work offline. Defaults to 'false'");
            OptionSet options = parser.parse(args);
            String stubs = (String)options.valueOf((OptionSpec)stubsOpt);
            boolean workOffline = options.has("wo");
            Integer minPortValue = (Integer)options.valueOf((OptionSpec)minPortValueOpt);
            Integer maxPortValue = (Integer)options.valueOf((OptionSpec)maxPortValueOpt);
            String stubRepositoryRoot = (String)options.valueOf((OptionSpec)rootOpt);
            String stubsSuffix = (String)options.valueOf((OptionSpec)classifierOpt);
            String username = (String)options.valueOf((OptionSpec)usernameOpt);
            String password = (String)options.valueOf((OptionSpec)passwordOpt);
            String proxyHost = (String)options.valueOf((OptionSpec)proxyHostOpt);
            Integer proxyPort = (Integer)options.valueOf((OptionSpec)proxyPortOpt);
            StubRunnerOptionsBuilder builder = new StubRunnerOptionsBuilder().withMinMaxPort(minPortValue, maxPortValue).withStubRepositoryRoot(stubRepositoryRoot).withWorkOffline(workOffline).withStubsClassifier(stubsSuffix).withUsername(username).withPassword(password).withStubs(stubs);
            if (proxyHost != null) {
                builder.withProxy(proxyHost, proxyPort);
            }
            StubRunnerOptions stubRunnerOptions = builder.build();
            this.arguments = new Arguments(stubRunnerOptions);
        }
        catch (Exception e) {
            this.printErrorMessage(e, parser);
            throw e;
        }
    }

    private void printErrorMessage(Exception e, OptionParser parser) throws IOException {
        System.err.println(e.getMessage());
        System.err.println("java -jar stub-runner.jar [options...] ");
        parser.printHelpOn((OutputStream)System.err);
        System.err.println();
        System.err.println("Example: java -jar stub-runner.jar ${parser.printExample(ALL)}");
    }

    public static void main(String[] args) throws Exception {
        new StubRunnerMain(args).execute();
    }

    private void execute() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Launching StubRunner with args: " + this.arguments);
            }
            BatchStubRunner stubRunner = new BatchStubRunnerFactory(this.arguments.getStubRunnerOptions()).buildBatchStubRunner();
            RunningStubs runningCollaborators = stubRunner.runStubs();
            log.info(runningCollaborators.toString());
        }
        catch (Exception e) {
            log.error("An exception occurred while trying to execute the stubs", (Throwable)e);
            throw e;
        }
    }
}

