/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;

public class StubRunnerOptions {
    final Integer minPortValue;
    final Integer maxPortValue;
    final String stubRepositoryRoot;
    final boolean workOffline;
    final String stubsClassifier;
    final Collection<StubConfiguration> dependencies;
    final Map<StubConfiguration, Integer> stubIdsToPortMapping;
    final String username;
    final String password;
    private final StubRunnerProxyOptions stubRunnerProxyOptions;
    private boolean stubsPerConsumer = false;
    private String consumerName;

    StubRunnerOptions(Integer minPortValue, Integer maxPortValue, String stubRepositoryRoot, boolean workOffline, String stubsClassifier, Collection<StubConfiguration> dependencies, Map<StubConfiguration, Integer> stubIdsToPortMapping, String username, String password, StubRunnerProxyOptions stubRunnerProxyOptions, boolean stubsPerConsumer, String consumerName) {
        this.minPortValue = minPortValue;
        this.maxPortValue = maxPortValue;
        this.stubRepositoryRoot = stubRepositoryRoot;
        this.workOffline = workOffline;
        this.stubsClassifier = stubsClassifier;
        this.dependencies = dependencies;
        this.stubIdsToPortMapping = stubIdsToPortMapping;
        this.username = username;
        this.password = password;
        this.stubRunnerProxyOptions = stubRunnerProxyOptions;
        this.stubsPerConsumer = stubsPerConsumer;
        this.consumerName = consumerName;
    }

    public Integer port(StubConfiguration stubConfiguration) {
        if (this.stubIdsToPortMapping != null) {
            return this.stubIdsToPortMapping.get(stubConfiguration);
        }
        return null;
    }

    public Integer getMinPortValue() {
        return this.minPortValue;
    }

    public Integer getMaxPortValue() {
        return this.maxPortValue;
    }

    public Collection<StubConfiguration> getDependencies() {
        return this.dependencies;
    }

    public Map<StubConfiguration, Integer> getStubIdsToPortMapping() {
        return this.stubIdsToPortMapping;
    }

    public String getStubRepositoryRoot() {
        return this.stubRepositoryRoot;
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public String getStubsClassifier() {
        return this.stubsClassifier;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public StubRunnerProxyOptions getStubRunnerProxyOptions() {
        return this.stubRunnerProxyOptions;
    }

    public StubRunnerProxyOptions getProxyOptions() {
        return this.stubRunnerProxyOptions;
    }

    public boolean isStubsPerConsumer() {
        return this.stubsPerConsumer;
    }

    public void setStubsPerConsumer(boolean stubsPerConsumer) {
        this.stubsPerConsumer = stubsPerConsumer;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String toString() {
        return "StubRunnerOptions{minPortValue=" + this.minPortValue + ", maxPortValue=" + this.maxPortValue + ", stubRepositoryRoot='" + this.stubRepositoryRoot + '\'' + ", workOffline=" + this.workOffline + ", stubsClassifier='" + this.stubsClassifier + '\'' + ", dependencies=" + this.dependencies + ", stubIdsToPortMapping=" + this.stubIdsToPortMapping + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", stubRunnerProxyOptions='" + this.stubRunnerProxyOptions + "', stubsPerConsumer='" + this.stubsPerConsumer + '\'' + ", stubsPerConsumer='" + this.stubsPerConsumer + '\'' + '}';
    }

    public static class StubRunnerProxyOptions {
        private final String proxyHost;
        private final int proxyPort;

        public StubRunnerProxyOptions(String proxyHost, int proxyPort) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String toString() {
            return "StubRunnerProxyOptions{proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
        }
    }
}

