/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerNoOpDiscoveryClient;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerServiceInstance;
import org.springframework.cloud.contract.stubrunner.util.StringUtils;

class StubRunnerDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final DiscoveryClient delegate;
    private final StubFinder stubFinder;
    private final StubMapperProperties stubMapperProperties;

    public StubRunnerDiscoveryClient(DiscoveryClient delegate, StubFinder stubFinder, StubMapperProperties stubMapperProperties, String springAppName) {
        DiscoveryClient discoveryClient = this.delegate = delegate instanceof StubRunnerDiscoveryClient ? this.noOpDiscoveryClient(springAppName) : delegate;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will delegate calls to discovery service [" + this.delegate + "] if a stub is not found"));
        }
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
    }

    public StubRunnerDiscoveryClient(StubFinder stubFinder, StubMapperProperties stubMapperProperties, String springAppName) {
        this.delegate = this.noOpDiscoveryClient(springAppName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will delegate calls to discovery service [" + this.delegate + "] if a stub is not found"));
        }
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
    }

    private StubRunnerNoOpDiscoveryClient noOpDiscoveryClient(String springAppName) {
        return new StubRunnerNoOpDiscoveryClient((ServiceInstance)new DefaultServiceInstance(springAppName, "localhost", 0, false));
    }

    public String description() {
        try {
            return this.delegate.description();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to fetch description from delegate", (Throwable)e);
            }
            return "";
        }
    }

    public ServiceInstance getLocalServiceInstance() {
        try {
            return this.delegate.getLocalServiceInstance();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to get local service instance from delegate", (Throwable)e);
            }
            return null;
        }
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        String ivyNotation = this.stubMapperProperties.fromServiceIdToIvyNotation(serviceId);
        String serviceToFind = StringUtils.hasText(ivyNotation) ? ivyNotation : serviceId;
        URL stubUrl = this.stubFinder.findStubUrl(serviceToFind);
        log.info((Object)("Resolved from ivy [" + ivyNotation + "] service to find [" + serviceToFind + "]. Found stub is available under URL [" + stubUrl + "]"));
        if (stubUrl == null) {
            return this.getInstancesFromDelegate(serviceId);
        }
        return Collections.singletonList(new StubRunnerServiceInstance(serviceId, stubUrl.getHost(), stubUrl.getPort(), this.toUri(stubUrl)));
    }

    private List<ServiceInstance> getInstancesFromDelegate(String serviceId) {
        try {
            return new ArrayList<ServiceInstance>(this.delegate.getInstances(serviceId));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to fetch instances from delegate", (Throwable)e);
            }
            return new ArrayList<ServiceInstance>();
        }
    }

    private URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getServices() {
        ArrayList<String> list = new ArrayList<String>();
        List<String> services = this.getServicesFromDelegate();
        RunningStubs runningStubs = this.stubFinder.findAllRunningStubs();
        list.addAll(services);
        list.addAll(runningStubs.getAllServicesNames());
        return list;
    }

    private List<String> getServicesFromDelegate() {
        try {
            return new ArrayList<String>(this.delegate.getServices());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to fetch services from delegate", (Throwable)e);
            }
            return new ArrayList<String>();
        }
    }
}

