/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DirectoryCopyingVisitor
extends SimpleFileVisitor<Path> {
    private static final Log log = LogFactory.getLog(DirectoryCopyingVisitor.class);
    private final Path from;
    private final Path to;

    DirectoryCopyingVisitor(Path from, Path to) {
        this.from = from;
        this.to = to;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will copy from [" + from.toString() + "] to [" + to.toString() + "]"));
        }
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.from.relativize(dir);
        if (".git".equals(relativePath.toString())) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Path targetPath = this.to.resolve(relativePath);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created a folder [" + targetPath.toString() + "]"));
            }
            Files.createDirectory(targetPath, new FileAttribute[0]);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Folder [" + targetPath.toString() + "] already exists"));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.to.resolve(this.from.relativize(file));
        Files.copy(file, relativePath, StandardCopyOption.REPLACE_EXISTING);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copied file from [" + file.toString() + "] to [" + relativePath.toString() + "]"));
        }
        return FileVisitResult.CONTINUE;
    }
}

