/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TemporaryFileStorage {
    private static final Log log = LogFactory.getLog(TemporaryFileStorage.class);
    private static final Queue<File> TEMP_FILES_LOG = new LinkedBlockingQueue<File>(1000);

    TemporaryFileStorage() {
    }

    static void add(File file) {
        TEMP_FILES_LOG.add(file);
    }

    static Queue<File> files() {
        return TEMP_FILES_LOG;
    }

    static void cleanup(boolean deleteStubsAfterTest) {
        block5: {
            if (!deleteStubsAfterTest) {
                log.info((Object)"Will not clear temporary files due to switch");
                return;
            }
            try {
                for (File file : TemporaryFileStorage.files()) {
                    if (file.isDirectory()) {
                        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Removing file [" + file + "]"));
                                }
                                Files.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Removing dir [" + dir + "]"));
                                }
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        continue;
                    }
                    Files.delete(file.toPath());
                }
            }
            catch (IOException | NoClassDefFoundError e) {
                if (!log.isTraceEnabled()) break block5;
                log.trace((Object)"Failed to remove temporary file", e);
            }
        }
    }

    static File createTempDir(String tempDirPrefix) {
        try {
            return Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create tmp dir with prefix: [" + tempDirPrefix + "]", e);
        }
    }
}

