/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.springframework.util.StringUtils;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilder;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuildingException;
import shaded.org.apache.maven.settings.building.SettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.transport.file.FileTransporterFactory;
import shaded.org.eclipse.aether.transport.http.HttpTransporterFactory;

class AetherFactories {
    private static final Log log = LogFactory.getLog(AetherFactories.class);
    private static final String MAVEN_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    private static final String MAVEN_USER_SETTINGS_LOCATION = "org.apache.maven.user-settings";
    private static final String MAVEN_GLOBAL_SETTINGS_LOCATION = "org.apache.maven.global-settings";
    private static final Random RANDOM = new Random();

    AetherFactories() {
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static RepositorySystemSession newSession(RepositorySystem system, boolean workOffline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(workOffline);
        if (!workOffline) {
            session.setUpdatePolicy("always");
        }
        session.setChecksumPolicy("warn");
        String localRepositoryDirectory = AetherFactories.localRepositoryDirectory(workOffline);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local Repository Directory set to [" + localRepositoryDirectory + "]. Work offline: [" + workOffline + "]"));
        }
        LocalRepository localRepo = new LocalRepository(localRepositoryDirectory);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    protected static String localRepositoryDirectory(boolean workOffline) {
        String localRepoLocationFromSettings = AetherFactories.settings().getLocalRepository();
        String currentLocalRepo = AetherFactories.readPropertyFromSystemProps(localRepoLocationFromSettings);
        if (workOffline) {
            return currentLocalRepo;
        }
        return AetherFactories.temporaryDirectory();
    }

    private static String temporaryDirectory() {
        try {
            return Files.createTempDirectory("aether-local", new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to create a new temporary directory, will generate a new one under temp dir");
            }
            return System.getProperty("java.io.tmpdir") + File.separator + RANDOM.nextInt();
        }
    }

    private static String readPropertyFromSystemProps(String localRepoLocationFromSettings) {
        String mavenLocalRepo = AetherFactories.fromSystemPropOrEnv(MAVEN_LOCAL_REPOSITORY_LOCATION);
        return StringUtils.hasText((String)mavenLocalRepo) ? mavenLocalRepo : (localRepoLocationFromSettings != null ? localRepoLocationFromSettings : System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository");
    }

    private static String fromSystemPropOrEnv(String prop) {
        String resolvedProp = System.getProperty(prop);
        if (StringUtils.hasText((String)resolvedProp)) {
            return resolvedProp;
        }
        return System.getenv(prop);
    }

    private static File userSettings() {
        String user = AetherFactories.fromSystemPropOrEnv(MAVEN_USER_SETTINGS_LOCATION);
        if (user == null) {
            return new File(new File(System.getProperty("user.home")).getAbsoluteFile(), File.separator + ".m2" + File.separator + "settings.xml");
        }
        return new File(user);
    }

    private static Settings settings() {
        SettingsBuildingResult result;
        DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(AetherFactories.userSettings());
        String global = AetherFactories.fromSystemPropOrEnv(MAVEN_GLOBAL_SETTINGS_LOCATION);
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            result = builder.build((SettingsBuildingRequest)request);
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
        return result.getEffectiveSettings();
    }
}

