/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ResourceResolver {
    private static final Log log = LogFactory.getLog(ResourceResolver.class);
    private static final List<ProtocolResolver> RESOLVERS = new ArrayList<ProtocolResolver>();
    private static final DefaultResourceLoader LOADER = new DefaultResourceLoader();

    public static Resource resource(String url) {
        try {
            return LOADER.getResource(url);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to read the resource [" + url + "]"), (Throwable)e);
            return null;
        }
    }

    static {
        RESOLVERS.addAll(SpringFactoriesLoader.loadFactories(StubDownloaderBuilder.class, null));
        RESOLVERS.addAll(new StubDownloaderBuilderProvider().defaultStubDownloaderBuilders());
        for (ProtocolResolver resolver : RESOLVERS) {
            LOADER.addProtocolResolver(resolver);
        }
    }
}

