/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.contract.stubrunner.ResourceResolver;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="stubrunner")
public class StubRunnerProperties {
    private int minPort = 10000;
    private int maxPort = 15000;
    private Resource repositoryRoot;
    private String[] ids = new String[0];
    private String classifier = "stubs";
    private String username;
    private String password;
    private Integer proxyPort;
    private String proxyHost;
    private boolean stubsPerConsumer;
    private String consumerName;
    private String mappingsOutputFolder;
    private StubsMode stubsMode;
    private boolean deleteStubsAfterTest = true;
    private Map<String, String> properties = new HashMap<String, String>();

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public Resource getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void setRepositoryRoot(String repositoryRoot) {
        this.repositoryRoot = ResourceResolver.resource(repositoryRoot);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean isStubsPerConsumer() {
        return this.stubsPerConsumer;
    }

    public void setStubsPerConsumer(boolean stubsPerConsumer) {
        this.stubsPerConsumer = stubsPerConsumer;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getMappingsOutputFolder() {
        return this.mappingsOutputFolder;
    }

    public void setMappingsOutputFolder(String mappingsOutputFolder) {
        this.mappingsOutputFolder = mappingsOutputFolder;
    }

    public StubsMode getStubsMode() {
        return this.stubsMode;
    }

    public void setStubsMode(StubsMode stubsMode) {
        this.stubsMode = stubsMode;
    }

    public boolean isDeleteStubsAfterTest() {
        return this.deleteStubsAfterTest;
    }

    public void setDeleteStubsAfterTest(boolean deleteStubsAfterTest) {
        this.deleteStubsAfterTest = deleteStubsAfterTest;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        Properties elements = StringUtils.splitArrayElementsIntoProperties((String[])properties, (String)"=");
        if (elements == null) {
            return;
        }
        for (String key : elements.stringPropertyNames()) {
            this.properties.put(key, elements.getProperty(key));
        }
    }

    public String toString() {
        return "StubRunnerProperties{minPort=" + this.minPort + ", maxPort=" + this.maxPort + ", repositoryRoot=" + this.repositoryRoot + ", ids=" + Arrays.toString(this.ids) + ", classifier='" + this.classifier + '\'' + ", setStubsPerConsumer='" + this.stubsPerConsumer + "', consumerName='" + this.consumerName + '\'' + ", stubsMode='" + (Object)((Object)this.stubsMode) + '\'' + ", size of properties=" + this.properties.size() + '}';
    }

    public static enum StubsMode {
        CLASSPATH,
        LOCAL,
        REMOTE;

    }
}

