/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AvailablePortScanner {
    private static final Log log = LogFactory.getLog(AvailablePortScanner.class);
    private static final int MAX_RETRY_COUNT = 1000;
    private final int minPortNumber;
    private final int maxPortNumber;
    private final int maxRetryCount;

    AvailablePortScanner(int minPortNumber, int maxPortNumber) {
        this(minPortNumber, maxPortNumber, 1000);
    }

    AvailablePortScanner(int minPortNumber, int maxPortNumber, int maxRetryCount) {
        this.checkPortRanges(minPortNumber, maxPortNumber);
        this.minPortNumber = minPortNumber;
        this.maxPortNumber = maxPortNumber;
        this.maxRetryCount = maxRetryCount;
    }

    private void checkPortRanges(int minPortNumber, int maxPortNumber) {
        if (minPortNumber > maxPortNumber) {
            throw new InvalidPortRange(minPortNumber, maxPortNumber);
        }
    }

    public <T> T tryToExecuteWithFreePort(PortCallback<T> closure) {
        for (int i = 0; i < this.maxRetryCount; ++i) {
            try {
                int numberOfPortsToBind = this.maxPortNumber - this.minPortNumber + 1;
                int portToScan = new Random().nextInt(numberOfPortsToBind) + this.minPortNumber;
                this.checkIfPortIsAvailable(portToScan);
                return this.executeLogicForAvailablePort(portToScan, closure);
            }
            catch (IOException exception) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Failed to execute callback (try: " + i + "/" + this.maxRetryCount + ")"), (Throwable)exception);
                continue;
            }
        }
        throw new NoPortAvailableException(this.minPortNumber, this.maxPortNumber);
    }

    private <T> T executeLogicForAvailablePort(int portToScan, PortCallback<T> closure) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to execute closure with port [" + portToScan + "]"));
        }
        return closure.call(portToScan);
    }

    private void checkIfPortIsAvailable(int portToScan) throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(portToScan);
        }
    }

    public static interface PortCallback<T> {
        public T call(int var1) throws IOException;
    }

    static class InvalidPortRange
    extends RuntimeException {
        InvalidPortRange(int lowerBound, int upperBound) {
            super("Invalid bounds exceptions, min port [" + lowerBound + "] is greater to max port [" + upperBound + "]");
        }
    }

    static class NoPortAvailableException
    extends RuntimeException {
        NoPortAvailableException(int lowerBound, int upperBound) {
            super("Could not find available port in range " + lowerBound + ":" + upperBound);
        }
    }
}

