/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.util.NamesUtil;

class FileSaver
implements GroovyObject {
    private final File targetDirectory;
    private final SingleTestGenerator generator;
    private final ContractVerifierConfigProperties properties;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public FileSaver(File targetDirectory, SingleTestGenerator generator, ContractVerifierConfigProperties properties) {
        ContractVerifierConfigProperties contractVerifierConfigProperties;
        SingleTestGenerator singleTestGenerator;
        File file;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.targetDirectory = file = targetDirectory;
        this.generator = singleTestGenerator = generator;
        this.properties = contractVerifierConfigProperties = properties;
    }

    public void saveClassFile(Path classPath, byte ... classBytes) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info((Object)new GStringImpl(new Object[]{classPath}, new String[]{"Creating new class file [", "]"}));
            v0 = null;
        } else {
            v0 = null;
        }
        Files.write(classPath, classBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    protected Path pathToClass(Path testBaseDir, String fileName) {
        return Paths.get(testBaseDir.toString(), StringGroovyMethods.plus((String)NamesUtil.capitalize(fileName), (CharSequence)this.generator.fileExtension(this.properties))).toAbsolutePath();
    }

    protected Path generateTestBaseDir(String basePackageClass, String includedDirectoryRelativePath) {
        Path testBaseDir = Paths.get(this.targetDirectory.getAbsolutePath(), NamesUtil.packageToDirectory(basePackageClass), NamesUtil.beforeLast(includedDirectoryRelativePath, File.separator));
        Files.createDirectories(testBaseDir, new FileAttribute[0]);
        return testBaseDir;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileSaver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        FileSaver.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.FileSaver");
    }
}

