/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Map;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class MockMvcMultipartGiven
implements Given {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final BodyReader bodyReader;
    private final BodyParser bodyParser;

    MockMvcMultipartGiven(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyReader = new BodyReader(generatedClassMetaData);
        this.bodyParser = bodyParser;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.getMultipartParameters(metadata).entrySet().forEach(entry -> this.blockBuilder.addLine(this.getMultipartParameterLine(metadata, (Map.Entry<String, Object>)entry)));
        return this;
    }

    private String getMultipartParameterLine(SingleContractMetadata metadata, Map.Entry<String, Object> parameter) {
        if (parameter.getValue() instanceof NamedProperty) {
            return ".multiPart(" + this.getMultipartFileParameterContent(metadata, parameter.getKey(), (NamedProperty)parameter.getValue()) + ")";
        }
        return this.getParameterString(parameter);
    }

    private Map<String, Object> getMultipartParameters(SingleContractMetadata metadata) {
        return (Map)metadata.getContract().getRequest().getMultipart().getServerValue();
    }

    private String getMultipartFileParameterContent(SingleContractMetadata metadata, String propertyName, NamedProperty propertyValue) {
        return ContentUtils.getJavaMultipartFileParameterContent(propertyName, propertyValue, fileProp -> this.bodyReader.readBytesFromFileString(metadata, (FromFileProperty)fileProp, CommunicationType.REQUEST));
    }

    private String getParameterString(Map.Entry<String, Object> parameter) {
        return ".param(" + this.bodyParser.quotedShortText(parameter.getKey()) + ", " + this.bodyParser.quotedShortText(MapConverter.getTestSideValuesForNonBody(parameter.getValue())) + ")";
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        return request != null && request.getMultipart() != null && this.generatedClassMetaData.configProperties.getTestFramework() != TestFramework.SPOCK;
    }
}

