/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.kafka;

import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class Record {
    private final ConsumerRecord record;

    Record(ConsumerRecord record) {
        this.record = record;
    }

    private Map<String, Object> toMap(Headers headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Header header : headers) {
            map.put(header.key(), header.value());
        }
        return map;
    }

    Message toMessage() {
        Object textPayload = this.record.value();
        MessageHeaders headers = new MessageHeaders(this.toMap(this.record.headers()));
        if (textPayload instanceof String && ((String)textPayload).contains("payload") && ((String)textPayload).contains("headers")) {
            try {
                Object object = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse((String)textPayload);
                JSONObject jo = (JSONObject)object;
                String payload = (String)jo.get((Object)"payload");
                JSONObject headersInJson = (JSONObject)jo.get((Object)"headers");
                HashMap newHeaders = new HashMap(headers);
                newHeaders.putAll(headersInJson);
                return MessageBuilder.createMessage((Object)this.unquoted(payload), (MessageHeaders)new MessageHeaders(newHeaders));
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return MessageBuilder.createMessage((Object)this.unquoted(textPayload), (MessageHeaders)headers);
    }

    private Object unquoted(Object value) {
        String textPayload;
        String string = textPayload = value instanceof byte[] ? new String((byte[])value) : value.toString();
        if (textPayload.startsWith("\"") && textPayload.endsWith("\"")) {
            return textPayload.substring(1, textPayload.length() - 1).replace("\\\"", "\"");
        }
        return textPayload;
    }
}

