/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ToYamlConverter
implements GroovyObject {
    private static YamlContractConverter yamlContractConverter;
    private static final List<ContractConverter> CONTRACT_CONVERTERS;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private ToYamlConverter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        throw (Throwable)new IllegalStateException("Can't instantiate a utility class");
    }

    protected static void doReplaceContractWithYaml(ContractConverter converter, File file) {
        Reference file2 = new Reference((Object)file);
        Collection collection = converter.convertFrom((File)file2.get());
        if (log.isDebugEnabled()) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Converted file [", (Object)((File)file2.get())), (CharSequence)"] to collection of ["), (Object)collection.size()), (CharSequence)"] contracts"));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        Object yamls = yamlContractConverter.convertTo(collection);
        if (log.isDebugEnabled()) {
            Object v1;
            if (log.isDebugEnabled()) {
                log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Converted collection of [", (Object)collection.size()), (CharSequence)"] contracts to ["), (Object)yamls.size()), (CharSequence)"] YAML contracts"));
                v1 = null;
            } else {
                v1 = null;
            }
        }
        ((File)file2.get()).delete();
        Map<String, byte[]> stored = yamlContractConverter.store((List<YamlContract>)yamls);
        if (log.isDebugEnabled()) {
            Object v2;
            if (log.isDebugEnabled()) {
                log.debug((Object)StringGroovyMethods.plus((CharSequence)"Dumped YAMLs to following file names ", stored.keySet()));
                v2 = null;
            } else {
                v2 = null;
            }
        }
        public final class _doReplaceContractWithYaml_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference file;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doReplaceContractWithYaml_closure1(Object _outerInstance, Object _thisObject, Reference file) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.file = reference = file;
            }

            public Object doCall(Object it) {
                File ymlContractVersion = new File(((File)this.file.get()).getParentFile(), ShortTypeHandling.castToString(((Map.Entry)it).getKey()));
                Files.write(ymlContractVersion.toPath(), (byte[])ScriptBytecodeAdapter.castToType(((Map.Entry)it).getValue(), byte[].class), new OpenOption[0]);
                if (log.isDebugEnabled()) {
                    Object v0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Written file [", (Object)ymlContractVersion), (CharSequence)"] with YAML contract definition"));
                        v0 = null;
                    } else {
                        v0 = null;
                    }
                    return v0;
                }
                return null;
            }

            public File getFile() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doReplaceContractWithYaml_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(stored.entrySet(), (Closure)new _doReplaceContractWithYaml_closure1(ToYamlConverter.class, ToYamlConverter.class, file2));
    }

    public static void replaceContractWithYaml(File baseDir) {
        public final class _replaceContractWithYaml_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _replaceContractWithYaml_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File file) {
                Reference file2 = new Reference((Object)file);
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference file;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference file) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.file = reference = file;
                    }

                    public Object doCall(Object it) {
                        return ((ContractConverter)it).isAccepted((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class));
                    }

                    public File getFile() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ContractConverter converter = (ContractConverter)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(CONTRACT_CONVERTERS, (Closure)new _closure3((Object)this, this.getThisObject(), file2)), ContractConverter.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)converter)) {
                    if (log.isDebugEnabled()) {
                        Object v0;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)new GStringImpl(new Object[]{((File)file2.get()).getName()}, new String[]{"Will replace contract [", "] with a YAML version"}));
                            v0 = null;
                        } else {
                            v0 = null;
                        }
                    }
                    return InvokerHelper.invokeStaticMethod(ToYamlConverter.class, (String)"doReplaceContractWithYaml", (Object)new Object[]{converter, (File)file2.get()});
                }
                return null;
            }

            public Object call(File file) {
                Reference file2 = new Reference((Object)file);
                return this.doCall((File)file2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _replaceContractWithYaml_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.eachFileRecurse((File)baseDir, (Closure)new _replaceContractWithYaml_closure2(ToYamlConverter.class, ToYamlConverter.class));
    }

    private static List<ContractConverter> converters() {
        List converters = SpringFactoriesLoader.loadFactories(ContractConverter.class, null);
        converters.add(YamlContractConverter.INSTANCE);
        converters.add(ContractVerifierDslConverter.INSTANCE);
        return converters;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ToYamlConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        YamlContractConverter yamlContractConverter;
        ToYamlConverter.yamlContractConverter = yamlContractConverter = new YamlContractConverter();
        List<ContractConverter> list = ToYamlConverter.converters();
        CONTRACT_CONVERTERS = list;
        ToYamlConverter.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.converter.ToYamlConverter");
    }
}

