/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import org.springframework.cloud.contract.spec.internal.Cookie;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ContentHelper;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MockMvcCookiesGiven
implements Given {
    private final BlockBuilder blockBuilder;

    MockMvcCookiesGiven(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.processInput(metadata.getContract().getRequest());
        return this;
    }

    private void processInput(Request request) {
        Iterator iterator = request.getCookies().getEntries().iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            if (this.ofAbsentType(cookie)) {
                return;
            }
            if (iterator.hasNext()) {
                this.blockBuilder.addLine(this.string(cookie));
                continue;
            }
            this.blockBuilder.addIndented(this.string(cookie));
        }
    }

    private String string(Cookie cookie) {
        return ".cookie(" + ContentHelper.getTestSideForNonBodyValue(cookie.getKey()) + ", " + ContentHelper.getTestSideForNonBodyValue(cookie.getServerValue()) + ")";
    }

    private boolean ofAbsentType(Cookie cookie) {
        return cookie.getServerValue() instanceof MatchingStrategy && MatchingStrategy.Type.ABSENT.equals((Object)((MatchingStrategy)cookie.getServerValue()).getType());
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        return request != null && request.getCookies() != null;
    }
}

