/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MessagingBodyWhen
implements When {
    private final BlockBuilder blockBuilder;
    private final BodyReader bodyReader;

    MessagingBodyWhen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData) {
        this.blockBuilder = blockBuilder;
        this.bodyReader = new BodyReader(metaData);
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        this.bodyReader.storeContractAsYaml(metadata);
        this.blockBuilder.addIndented("contractVerifierMessaging.send(inputMessage, \"" + (String)metadata.getContract().getInput().getMessageFrom().getServerValue() + "\",").addEmptyLine().indent().addIndented("contract(this, \"" + metadata.methodName() + ".yml\"))").addEndingIfNotPresent().unindent();
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getInput().getMessageFrom() != null;
    }
}

