/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder.handlebars;

import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;

public class HandlebarsEscapeHelper
implements Helper<Map<String, Object>> {
    public static final String NAME = "escapejsonbody";
    public static final String REQUEST_MODEL_NAME = "request";

    public Object apply(Map<String, Object> context, Options options) throws IOException {
        Object model = context.get(REQUEST_MODEL_NAME);
        if (model instanceof TestSideRequestTemplateModel) {
            return StringEscapeUtils.escapeJson((String)this.returnObjectForTest(model).toString());
        }
        if (model instanceof RequestTemplateModel) {
            return StringEscapeUtils.escapeJson((String)this.returnObjectForStub(model).toString());
        }
        throw new IllegalArgumentException("Unsupported model");
    }

    private Object returnObjectForStub(Object model) {
        return ((RequestTemplateModel)model).getBody();
    }

    private Object returnObjectForTest(Object model) {
        return ((TestSideRequestTemplateModel)model).getEscapedBody();
    }
}

