/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.springframework.cloud.contract.verifier.util.xml.FieldAssertion;
import org.springframework.cloud.contract.verifier.util.xml.XmlAsserterConfiguration;
import org.springframework.cloud.contract.verifier.util.xml.XmlCachedObjects;
import org.springframework.cloud.contract.verifier.util.xml.XmlVerifiable;
import org.w3c.dom.Document;

public final class XmlAssertion {
    private static final Map<String, XmlCachedObjects> CACHE = new ConcurrentHashMap<String, XmlCachedObjects>();
    private final XmlCachedObjects cachedObjects;
    private final LinkedList<String> xPathBuffer = new LinkedList();
    private final LinkedList<String> specialCaseXPathBuffer = new LinkedList();
    private final XmlAsserterConfiguration xmlAsserterConfiguration = new XmlAsserterConfiguration();

    private XmlAssertion(Document parsedXml) {
        this.cachedObjects = new XmlCachedObjects(parsedXml);
    }

    private XmlAssertion(String xml) {
        XmlCachedObjects cachedObjects = CACHE.get(xml);
        if (cachedObjects == null && !this.empty(xml)) {
            try {
                ByteArrayInputStream inputXml = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                XercesLoader loader = new XercesLoader();
                Document document = loader.load((InputStream)inputXml);
                cachedObjects = new XmlCachedObjects(document, xml);
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception occurred while trying to parse the XML", e);
            }
            CACHE.put(xml, cachedObjects);
        }
        this.cachedObjects = cachedObjects;
    }

    public static XmlVerifiable assertThat(String xml) {
        return new XmlAssertion(xml).root();
    }

    public static XmlVerifiable assertThat(Document parsedXml) {
        return new XmlAssertion(parsedXml).root();
    }

    public static XmlVerifiable assertThatXml(String body) {
        return XmlAssertion.assertThat(body);
    }

    public static XmlVerifiable assertThatXml(Document parsedXml) {
        return XmlAssertion.assertThat(parsedXml);
    }

    private boolean empty(String text) {
        return text == null || text.length() == 0 || text.matches("^\\s*$");
    }

    private XmlVerifiable root() {
        return new FieldAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, "", this.xmlAsserterConfiguration).node("");
    }
}

