/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.stream.binder.test.OutputDestination;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;

class StreamOutputDestinationMessageReceiver
implements MessageVerifierReceiver<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamOutputDestinationMessageReceiver.class);
    private final ApplicationContext context;

    StreamOutputDestinationMessageReceiver(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit, YamlContract contract) {
        try {
            OutputDestination outputDestination = (OutputDestination)this.context.getBean(OutputDestination.class);
            return outputDestination.receive(timeUnit.toMillis(timeout), destination);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to read a message from  a channel with name [" + destination + "]"), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Message<?> receive(String destination, YamlContract contract) {
        return this.receive(destination, 5L, TimeUnit.SECONDS, contract);
    }
}

