/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.util.DslParseException;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.util.ObjectUtils;

public class ContractVerifierDslConverter
implements ContractConverter<Collection<Contract>> {
    private static final Logger LOG = LoggerFactory.getLogger(ContractVerifierDslConverter.class);
    public static final ContractVerifierDslConverter INSTANCE = new ContractVerifierDslConverter();
    private static final Pattern PACKAGE_PATTERN = Pattern.compile(".*package (.+?);.+?", 32);
    private static final Pattern CLASS_PATTERN = Pattern.compile(".+?class (.+?)( |\\{).+?", 32);
    private static final JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();

    public static Collection<Contract> convertAsCollection(File rootFolder, String dsl) {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        try {
            ClassLoader urlCl = ContractVerifierDslConverter.updatedClassLoader(rootFolder, classLoader);
            Object object = ContractVerifierDslConverter.groovyShell(urlCl, rootFolder).evaluate(dsl);
            Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(object);
            return collection;
        }
        catch (DslParseException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception occurred while trying to evaluate the contract", (Throwable)e);
            throw new DslParseException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static Collection<Contract> convertAsCollection(File dsl) {
        return ContractVerifierDslConverter.convertAsCollection(dsl.getParentFile(), dsl);
    }

    public static Collection<Contract> convertAsCollection(File rootFolder, File dsl) {
        ClassLoader classLoader = ContractVerifierDslConverter.class.getClassLoader();
        try {
            ClassLoader urlCl = ContractVerifierDslConverter.updatedClassLoader(rootFolder, classLoader);
            Object object = ContractVerifierDslConverter.toObject(urlCl, rootFolder, dsl);
            Collection<Contract> collection = ContractVerifierDslConverter.listOfContracts(dsl, object);
            return collection;
        }
        catch (DslParseException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception occurred while trying to evaluate the contract at path [" + dsl.getPath() + "]", (Throwable)e);
            throw new DslParseException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static ClassLoader updatedClassLoader(File rootFolder, ClassLoader classLoader) {
        URLClassLoader urlCl;
        try {
            urlCl = URLClassLoader.newInstance(Collections.singletonList(rootFolder.toURI().toURL()).toArray(new URL[0]), classLoader);
        }
        catch (MalformedURLException e) {
            LOG.error("Exception occurred while trying to construct the URL from the root folder at path [" + rootFolder.getPath() + "]", (Throwable)e);
            throw new DslParseException(e);
        }
        ContractVerifierDslConverter.updateTheThreadClassLoader(urlCl);
        return urlCl;
    }

    private static void updateTheThreadClassLoader(ClassLoader urlCl) {
        Thread.currentThread().setContextClassLoader(urlCl);
    }

    private static Object toObject(ClassLoader cl, File rootFolder, File dsl) throws IOException {
        if (ContractVerifierDslConverter.isJava(dsl)) {
            try {
                return ContractVerifierDslConverter.parseJavaFile(rootFolder, dsl);
            }
            catch (Exception ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Exception occurred while trying to parse the file [" + dsl + "] as a contract. Will not parse it.", (Throwable)ex);
                }
                return null;
            }
        }
        return ContractVerifierDslConverter.groovyShell(cl, rootFolder).evaluate(dsl);
    }

    private static Object parseJavaFile(File rootFolder, File dsl) throws IllegalAccessException, InvocationTargetException, InstantiationException, IOException, NoSuchMethodException {
        Constructor<?> constructor = ContractVerifierDslConverter.classConstructor(rootFolder, dsl);
        Object newInstance = constructor.newInstance(new Object[0]);
        if (!(newInstance instanceof Supplier)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The class [" + dsl + "] is not instance of Supplier. Will not parse it as a contract");
            }
            return null;
        }
        Supplier supplier = (Supplier)newInstance;
        return supplier.get();
    }

    /*
     * Exception decompiling
     */
    private static Constructor<?> classConstructor(File rootFolder, File dsl) throws IllegalAccessException, IOException, NoSuchMethodException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void appendUrlsFromAllClassLoaders(Set<File> files) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            ContractVerifierDslConverter.appendUrlsFromClasspath(files, classLoader);
            while (classLoader.getParent() != null) {
                classLoader = classLoader.getParent();
                ContractVerifierDslConverter.appendUrlsFromClasspath(files, classLoader);
            }
        }
    }

    private static void appendUrlsFromClasspath(Set<File> files, ClassLoader classLoader) {
        URLClassLoader urlClassLoader;
        URL[] urLs;
        if (classLoader instanceof URLClassLoader && (urLs = (urlClassLoader = (URLClassLoader)classLoader).getURLs()).length > 0) {
            Arrays.stream(urLs).forEach(url -> files.add(new File(url.getFile())));
        }
    }

    private static boolean isJava(File dsl) {
        return dsl.getName().endsWith(".java");
    }

    private static String fqn(String classText) throws IllegalAccessException {
        Matcher classMatcher;
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(classText);
        Object fqn = "";
        if (packageMatcher.matches()) {
            fqn = packageMatcher.group(1) + ".";
        }
        if (!(classMatcher = CLASS_PATTERN.matcher(classText)).matches()) {
            throw new IllegalAccessException("Can't parse the class name");
        }
        return (String)fqn + classMatcher.group(1);
    }

    private static GroovyShell groovyShell(ClassLoader cl, File rootFolder) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setSourceEncoding("UTF-8");
        compilerConfiguration.setClasspathList(Collections.singletonList(rootFolder.getAbsolutePath()));
        return new GroovyShell(cl, compilerConfiguration);
    }

    private static Collection<Contract> listOfContracts(Object object) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (!(object instanceof Contract)) {
            throw new DslParseException("Contract is not returning a Contract or list of Contracts");
        }
        return Collections.singletonList((Contract)object);
    }

    private static Collection<Contract> listOfContracts(File file, Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (ContractVerifierDslConverter.isACollectionOfContracts(object)) {
            return ContractVerifierDslConverter.withName(file, (Collection)object);
        }
        if (!(object instanceof Contract)) {
            throw new DslParseException("Contract is not returning a Contract or list of Contracts");
        }
        return ContractVerifierDslConverter.withName(file, Collections.singletonList((Contract)object));
    }

    private static boolean isACollectionOfContracts(Object object) {
        return object instanceof Collection && ((Collection)object).stream().allMatch(it -> it instanceof Contract);
    }

    private static Collection<Contract> withName(File file, Collection<Contract> contracts) {
        AtomicInteger counter = new AtomicInteger(0);
        return contracts.stream().peek(it -> {
            if (ContractVerifierDslConverter.contractNameEmpty(it)) {
                it.name(NamesUtil.defaultContractName(file, contracts, counter.get()));
            }
            counter.getAndIncrement();
        }).collect(Collectors.toList());
    }

    private static boolean contractNameEmpty(Contract it) {
        return it != null && ObjectUtils.isEmpty((Object)it.getName());
    }

    public boolean isAccepted(File file) {
        return file.getName().endsWith(".groovy") || file.getName().endsWith(".gvy") || file.getName().endsWith(".java");
    }

    public Collection<Contract> convertFrom(File file) {
        return ContractVerifierDslConverter.convertAsCollection(file);
    }

    public Collection<Contract> convertTo(Collection<Contract> contract) {
        return contract;
    }

    private static /* synthetic */ String lambda$classConstructor$0(Diagnostic d) {
        return "Error " + d.getMessage(Locale.getDefault()) + " on line " + d.getLineNumber() + " in " + d.getSource();
    }
}

