/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.Set;
import org.springframework.cloud.contract.spec.internal.Cookie;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class JaxRsRequestCookiesWhen
implements When {
    private final BlockBuilder blockBuilder;
    private final BodyParser bodyParser;

    JaxRsRequestCookiesWhen(BlockBuilder blockBuilder, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        this.appendCookies(metadata.getContract().getRequest());
        return this;
    }

    private void appendCookies(Request request) {
        Iterator iterator = request.getCookies().getEntries().stream().filter(cookie -> !this.cookieOfAbsentType((Cookie)cookie)).iterator();
        while (iterator.hasNext()) {
            Cookie cookie2 = (Cookie)iterator.next();
            String value = ".cookie(" + this.bodyParser.quotedShortText(cookie2.getKey()) + ", " + this.bodyParser.quotedShortText(MapConverter.getTestSideValuesForNonBody(cookie2.getServerValue())) + ")";
            if (iterator.hasNext()) {
                this.blockBuilder.addLine(value);
                continue;
            }
            this.blockBuilder.addIndented(value);
        }
    }

    private boolean cookieOfAbsentType(Cookie cookie) {
        return cookie.getServerValue() instanceof MatchingStrategy && ((MatchingStrategy)cookie.getServerValue()).getType() == MatchingStrategy.Type.ABSENT;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getRequest().getCookies() != null && !metadata.getContract().getRequest().getCookies().getEntries().isEmpty() && !this.hasOnlyAbsentCookies(metadata);
    }

    private boolean hasOnlyAbsentCookies(SingleContractMetadata metadata) {
        Set entries = metadata.getContract().getRequest().getCookies().getEntries();
        long filteredOut = entries.stream().filter(this::cookieOfAbsentType).count();
        return filteredOut == (long)entries.size();
    }
}

