/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class JaxRsResponseHeadersThen
implements Then {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final ComparisonBuilder comparisonBuilder;

    JaxRsResponseHeadersThen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = metaData;
        this.comparisonBuilder = comparisonBuilder;
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        this.validateResponseHeadersBlock(metadata);
        return this;
    }

    private void validateResponseHeadersBlock(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        Headers headers = response.getHeaders();
        Iterator iterator = headers.getEntries().iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            String text = this.processHeaderElement(header.getName(), header.getServerValue() instanceof NotToEscapePattern ? header.getServerValue() : MapConverter.getTestSideValues(header.getServerValue()));
            if (iterator.hasNext()) {
                this.blockBuilder.addLineWithEnding(text);
                continue;
            }
            this.blockBuilder.addIndented(text);
        }
    }

    private String processHeaderElement(String property, Object value) {
        if (value instanceof NotToEscapePattern) {
            return this.comparisonBuilder.assertThat("response.getHeaderString(\"" + property + "\")") + this.comparisonBuilder.createComparison(((NotToEscapePattern)value).getServerValue());
        }
        if (value instanceof Number) {
            return this.comparisonBuilder.assertThat("response.getHeaderString(\"" + property + "\")", value);
        }
        if (value instanceof ExecutionProperty) {
            return ((ExecutionProperty)value).insertValue("response.getHeaderString(\"" + property + "\")");
        }
        return this.comparisonBuilder.assertThat("response.getHeaderString(\"" + property + "\")") + this.comparisonBuilder.createComparison(value);
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getResponse().getHeaders() != null;
    }
}

