/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.cloud.contract.wiremock.ContainerProperties;
import org.springframework.cloud.contract.wiremock.WiremockServerConfiguration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

class SpringBootHttpServer
implements HttpServer,
ApplicationListener<ApplicationPreparedEvent> {
    private volatile boolean running;
    private Options options;
    private AdminRequestHandler adminRequestHandler;
    private StubRequestHandler stubRequestHandler;
    private ConfigurableApplicationContext context;

    public SpringBootHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        this.options = options;
        this.adminRequestHandler = adminRequestHandler;
        this.stubRequestHandler = stubRequestHandler;
    }

    public void start() {
        this.context = new SpringApplicationBuilder(new Object[]{WiremockServerConfiguration.class}).logStartupInfo(false).bannerMode(Banner.Mode.OFF).listeners(new ApplicationListener[]{this}).run(new String[0]);
        this.running = true;
    }

    public void stop() {
        if (this.context != null) {
            this.context.close();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int port() {
        return this.container().port();
    }

    public int httpsPort() {
        return this.container().httpsPort();
    }

    private ContainerProperties container() {
        if (this.context != null) {
            return (ContainerProperties)this.context.getBean(ContainerProperties.class);
        }
        return new ContainerProperties(this.options);
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        GenericApplicationContext context = (GenericApplicationContext)event.getApplicationContext();
        DefaultListableBeanFactory beanFactory = context.getDefaultListableBeanFactory();
        if (beanFactory.containsBean("wireMockOptions")) {
            return;
        }
        beanFactory.registerSingleton("wireMockOptions", (Object)this.options);
        beanFactory.registerSingleton("adminRequestHandler", (Object)this.adminRequestHandler);
        beanFactory.registerSingleton("stubRequestHandler", (Object)this.stubRequestHandler);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServerPropertiesPostProcessor());
    }

    class ServerPropertiesPostProcessor
    implements BeanPostProcessor {
        ServerPropertiesPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ServerProperties) {
                ServerProperties server = (ServerProperties)bean;
                server.setPort(Integer.valueOf(this.getPort()));
                this.setupHttps(server, SpringBootHttpServer.this.options.httpsSettings());
            }
            return bean;
        }

        private void setupHttps(ServerProperties server, HttpsSettings httpsSettings) {
            if (httpsSettings.port() < 0 || !httpsSettings.enabled()) {
                return;
            }
            Ssl ssl = server.getSsl();
            if (ssl == null) {
                ssl = new Ssl();
                server.setSsl(ssl);
            }
            ssl.setKeyStore(httpsSettings.keyStorePath());
            ssl.setKeyPassword(httpsSettings.keyStorePassword());
            if (httpsSettings.hasTrustStore()) {
                ssl.setTrustStore(httpsSettings.trustStorePath());
                ssl.setTrustStorePassword(httpsSettings.trustStorePassword());
            }
        }

        private int getPort() {
            if (SpringBootHttpServer.this.options.httpsSettings().port() >= 0) {
                return SpringBootHttpServer.this.options.httpsSettings().port();
            }
            return SpringBootHttpServer.this.options.portNumber();
        }
    }
}

