/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.jayway.jsonpath.JsonPath;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class JsonPathValue {
    private final JsonPath jsonPath;
    private final String expression;
    private final CharSequence actual;

    JsonPathValue(JsonPath jsonPath, CharSequence actual) {
        this.jsonPath = jsonPath;
        this.actual = actual;
        this.expression = jsonPath.getPath();
    }

    public void assertHasValue(Class<?> type, String expectedDescription) {
        Object value = this.getValue(true);
        if (value == null || this.isIndefiniteAndEmpty()) {
            throw new AssertionError((Object)this.getNoValueMessage());
        }
        if (type != null && !type.isInstance(value)) {
            throw new AssertionError((Object)this.getExpectedValueMessage(expectedDescription));
        }
    }

    private boolean isIndefiniteAndEmpty() {
        return !this.isDefinite() && this.isEmpty();
    }

    private boolean isDefinite() {
        return this.jsonPath.isDefinite();
    }

    private boolean isEmpty() {
        return ObjectUtils.isEmpty((Object)this.getValue(false));
    }

    public Object getValue(boolean required) {
        try {
            CharSequence json = this.actual;
            return this.jsonPath.read(json == null ? null : json.toString());
        }
        catch (Exception ex) {
            if (!required) {
                return null;
            }
            throw new AssertionError((Object)(this.getNoValueMessage() + ". " + ex.getMessage()));
        }
    }

    private String getNoValueMessage() {
        return "No value at JSON path \"" + this.expression + "\"";
    }

    private String getExpectedValueMessage(String expectedDescription) {
        return String.format("Expected %s at JSON path \"%s\" but found: %s", expectedDescription, this.expression, ObjectUtils.nullSafeToString((Object)StringUtils.quoteIfString((Object)this.getValue(false))));
    }
}

