/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.wiremock.AutoConfigureWireMock;
import org.springframework.cloud.contract.wiremock.WireMockConfiguration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public final class WireMockTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log log = LogFactory.getLog(WireMockTestExecutionListener.class);

    public void afterTestClass(TestContext testContext) {
        if (this.wireMockConfigurationMissing(testContext) || this.annotationMissing(testContext)) {
            return;
        }
        if (this.portIsFixed(testContext)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"You've used fixed ports for WireMock setup - will mark context as dirty. Please use random ports, as much as possible. Your tests will be faster and more reliable and thiswarning will go away");
            }
            testContext.markApplicationContextDirty(DirtiesContext.HierarchyMode.EXHAUSTIVE);
        }
    }

    private boolean annotationMissing(TestContext testContext) {
        if (((AutoConfigureWireMock[])testContext.getTestClass().getAnnotationsByType(AutoConfigureWireMock.class)).length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No @AutoConfigureWireMock annotation found on [" + testContext.getTestClass() + "]. Skipping"));
            }
            return true;
        }
        return false;
    }

    private boolean wireMockConfigurationMissing(TestContext testContext) {
        boolean missing;
        boolean bl = missing = !testContext.getApplicationContext().containsBean(WireMockConfiguration.class.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("WireMockConfiguration is missing [" + missing + "]"));
        }
        return missing;
    }

    private WireMockConfiguration wireMockConfig(TestContext testContext) {
        return (WireMockConfiguration)testContext.getApplicationContext().getBean(WireMockConfiguration.class);
    }

    private boolean portIsFixed(TestContext testContext) {
        WireMockConfiguration wireMockProperties = this.wireMockConfig(testContext);
        int httpPort = wireMockProperties.wireMock.getServer().getPort();
        int httpsPort = wireMockProperties.wireMock.getServer().getHttpsPort();
        return (httpPort != 0 || httpsPort != -1) && httpsPort != 0;
    }
}

