/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.core.io.Resource;

public class DelegatingApplicationConfigurationMetadataResolver
extends ApplicationConfigurationMetadataResolver {
    private List<ApplicationConfigurationMetadataResolver> delegates = new ArrayList<ApplicationConfigurationMetadataResolver>();

    public DelegatingApplicationConfigurationMetadataResolver(ApplicationConfigurationMetadataResolver ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public boolean supports(Resource app) {
        return true;
    }

    @Override
    public List<ConfigurationMetadataProperty> listProperties(Resource app, boolean exhaustive) {
        for (ApplicationConfigurationMetadataResolver delegate : this.delegates) {
            if (!delegate.supports(app)) continue;
            return delegate.listProperties(app, exhaustive);
        }
        return Collections.emptyList();
    }

    @Override
    public URLClassLoader createAppClassLoader(Resource app) {
        for (ApplicationConfigurationMetadataResolver delegate : this.delegates) {
            if (!delegate.supports(app)) continue;
            return delegate.createAppClassLoader(app);
        }
        return super.createAppClassLoader(app);
    }
}

