/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.util.Properties;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.rest.client.AppRegistryOperations;
import org.springframework.cloud.dataflow.rest.resource.AppRegistrationResource;
import org.springframework.cloud.dataflow.rest.resource.DetailedAppRegistrationResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AppRegistryTemplate
implements AppRegistryOperations {
    private static final String APPS_REL = "apps";
    private Link appsLink;
    protected RestTemplate restTemplate;

    public AppRegistryTemplate(RestTemplate restTemplate, ResourceSupport resourceSupport) {
        Assert.notNull((Object)resourceSupport, (String)"URI Resources can't be null");
        Assert.notNull((Object)resourceSupport.getLink(APPS_REL), (String)"Apps relation is required");
        this.restTemplate = restTemplate;
        this.appsLink = resourceSupport.getLink(APPS_REL);
    }

    @Override
    public PagedResources<AppRegistrationResource> list() {
        return this.list(null);
    }

    @Override
    public PagedResources<AppRegistrationResource> list(ApplicationType type) {
        String uri = this.appsLink.getHref() + "?size=2000" + (type == null ? "" : "&type=" + type.name());
        return (PagedResources)this.restTemplate.getForObject(uri, AppRegistrationResource.Page.class, new Object[0]);
    }

    @Override
    public void unregister(String name, ApplicationType applicationType) {
        String uri = this.appsLink.getHref() + "/{type}/{name}";
        this.restTemplate.delete(uri, new Object[]{applicationType.name(), name});
    }

    @Override
    public void unregister(String name, ApplicationType applicationType, String version) {
        String uri = this.appsLink.getHref() + "/{type}/{name}/{version}";
        this.restTemplate.delete(uri, new Object[]{applicationType.name(), name, version});
    }

    @Override
    public void unregisterAll() {
        this.restTemplate.delete(this.appsLink.getHref(), new Object[0]);
    }

    @Override
    public DetailedAppRegistrationResource info(String name, ApplicationType type, boolean exhaustive) {
        String uri = this.appsLink.getHref() + "/{type}/{name}?exhaustive={exhaustive}";
        return (DetailedAppRegistrationResource)this.restTemplate.getForObject(uri, DetailedAppRegistrationResource.class, new Object[]{type, name, exhaustive});
    }

    @Override
    public DetailedAppRegistrationResource info(String name, ApplicationType type, String version, boolean exhaustive) {
        String uri = this.appsLink.getHref() + "/{type}/{name}/{version}?exhaustive={exhaustive}";
        return (DetailedAppRegistrationResource)this.restTemplate.getForObject(uri, DetailedAppRegistrationResource.class, new Object[]{type, name, version, exhaustive});
    }

    @Override
    public AppRegistrationResource register(String name, ApplicationType type, String uri, String metadataUri, boolean force) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"uri", (Object)uri);
        if (metadataUri != null) {
            values.add((Object)"metadata-uri", (Object)metadataUri);
        }
        values.add((Object)"force", (Object)Boolean.toString(force));
        return (AppRegistrationResource)this.restTemplate.postForObject(this.appsLink.getHref() + "/{type}/{name}", (Object)values, AppRegistrationResource.class, new Object[]{type, name});
    }

    @Override
    public AppRegistrationResource register(String name, ApplicationType type, String version, String uri, String metadataUri, boolean force) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"uri", (Object)uri);
        if (metadataUri != null) {
            values.add((Object)"metadata-uri", (Object)metadataUri);
        }
        values.add((Object)"force", (Object)Boolean.toString(force));
        return (AppRegistrationResource)this.restTemplate.postForObject(this.appsLink.getHref() + "/{type}/{name}/{version}", (Object)values, AppRegistrationResource.class, new Object[]{type, name, version});
    }

    @Override
    public PagedResources<AppRegistrationResource> importFromResource(String uri, boolean force) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"uri", (Object)uri);
        values.add((Object)"force", (Object)Boolean.toString(force));
        return (PagedResources)this.restTemplate.postForObject(this.appsLink.getHref(), (Object)values, AppRegistrationResource.Page.class, new Object[0]);
    }

    @Override
    public PagedResources<AppRegistrationResource> registerAll(Properties apps, boolean force) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        StringBuffer buffer = new StringBuffer();
        for (String key : apps.stringPropertyNames()) {
            buffer.append(String.format("%s=%s\n", key, apps.getProperty(key)));
        }
        values.add((Object)APPS_REL, (Object)buffer.toString());
        values.add((Object)"force", (Object)Boolean.toString(force));
        return (PagedResources)this.restTemplate.postForObject(this.appsLink.getHref(), (Object)values, AppRegistrationResource.Page.class, new Object[0]);
    }

    @Override
    public void makeDefault(String name, ApplicationType type, String version) {
        this.restTemplate.put(this.appsLink.getHref() + "/{type}/{name}/{version}", null, new Object[]{type, name, version});
    }
}

