/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import org.springframework.cloud.dataflow.rest.client.RuntimeOperations;
import org.springframework.cloud.dataflow.rest.resource.AppStatusResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.web.client.RestTemplate;

public class RuntimeTemplate
implements RuntimeOperations {
    private final RestTemplate restTemplate;
    private final Link appStatusesUriTemplate;
    private final Link appStatusUriTemplate;

    RuntimeTemplate(RestTemplate restTemplate, ResourceSupport resources) {
        this.restTemplate = restTemplate;
        this.appStatusesUriTemplate = resources.getLink("runtime/apps");
        this.appStatusUriTemplate = resources.getLink("runtime/apps/app");
    }

    @Override
    public PagedResources<AppStatusResource> status() {
        String uriTemplate = this.appStatusesUriTemplate.expand(new Object[0]).getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedResources)this.restTemplate.getForObject(uriTemplate, AppStatusResource.Page.class, new Object[0]);
    }

    @Override
    public AppStatusResource status(String deploymentId) {
        return (AppStatusResource)this.restTemplate.getForObject(this.appStatusUriTemplate.expand(new Object[]{deploymentId}).getHref(), AppStatusResource.class, new Object[0]);
    }
}

