/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl;

import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.dsl.AbstractPropertiesBuilder;
import org.springframework.util.Assert;

public class DeploymentPropertiesBuilder
extends AbstractPropertiesBuilder {
    public DeploymentPropertiesBuilder put(String key, String value) {
        this.deploymentProperties.put(key, value.toString());
        return this;
    }

    public DeploymentPropertiesBuilder putAll(Map<String, String> map) {
        this.deploymentProperties.putAll(map);
        return this;
    }

    public DeploymentPropertiesBuilder memory(String label, Integer memory) {
        Assert.notNull((Object)memory, (String)"Memory value can't be null");
        Assert.hasLength((String)label, (String)"Application name/label can not be empty");
        Assert.isTrue((memory >= 128 ? 1 : 0) != 0, (String)"Memory value must be greater or equal than 128mb");
        this.deploymentProperties.put(String.format("deployer.%s.%s", label, "memory"), memory.toString());
        return this;
    }

    public DeploymentPropertiesBuilder count(String label, Integer instances) {
        Assert.notNull((Object)instances, (String)"Number of instances can't be null");
        Assert.hasLength((String)label, (String)"Application name/label can not be empty");
        Assert.isTrue((instances > 0 ? 1 : 0) != 0, (String)"Number of instances must be greater than zero");
        this.deploymentProperties.put(String.format("deployer.%s.%s", label, "count"), instances.toString());
        return this;
    }
}

