/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.MapperFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.adapter.aws.AWSCompanionAutoConfiguration;
import org.springframework.cloud.function.adapter.aws.AWSLambdaUtils;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class FunctionInvoker
implements RequestStreamHandler {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private JsonMapper jsonMapper;
    private SimpleFunctionRegistry.FunctionInvocationWrapper function;
    private volatile String functionDefinition;

    public FunctionInvoker(String functionDefinition) {
        this.functionDefinition = functionDefinition;
        this.start();
    }

    public FunctionInvoker() {
        this(null);
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        Message<byte[]> requestMessage = AWSLambdaUtils.generateMessage(StreamUtils.copyToByteArray((InputStream)input), this.function.getInputType(), this.function.isSupplier(), this.jsonMapper, context);
        Object response = this.function.apply(requestMessage);
        byte[] responseBytes = this.buildResult(requestMessage, response);
        StreamUtils.copy((byte[])responseBytes, (OutputStream)output);
    }

    private byte[] buildResult(Message<?> requestMessage, Object output) throws IOException {
        Message responseMessage = null;
        if (output instanceof Publisher) {
            ArrayList result = new ArrayList();
            for (Object value : Flux.from((Publisher)((Publisher)output)).toIterable()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response value: " + value));
                }
                result.add(value);
            }
            output = result.size() > 1 ? result : (result.size() == 1 ? result.get(0) : null);
            if (output != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OUTPUT: " + output + " - " + output.getClass().getName()));
                }
                byte[] payload = this.jsonMapper.toJson(output);
                responseMessage = MessageBuilder.withPayload((Object)payload).build();
            }
        } else {
            responseMessage = (Message)output;
        }
        return AWSLambdaUtils.generateOutput(requestMessage, responseMessage, this.jsonMapper, this.function.getOutputType());
    }

    private void start() {
        Class startClass = FunctionClassUtils.getStartClass();
        String[] properties = new String[]{"--spring.cloud.function.web.export.enabled=false", "--spring.main.web-application-type=none"};
        ConfigurableApplicationContext context = ApplicationContextInitializer.class.isAssignableFrom(startClass) ? FunctionalSpringApplication.run((Class[])new Class[]{startClass, AWSCompanionAutoConfiguration.class}, (String[])properties) : SpringApplication.run((Class[])new Class[]{startClass, AWSCompanionAutoConfiguration.class}, (String[])properties);
        ConfigurableEnvironment environment = context.getEnvironment();
        if (!StringUtils.hasText((String)this.functionDefinition)) {
            this.functionDefinition = environment.getProperty("spring.cloud.function.definition");
        }
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        this.jsonMapper = (JsonMapper)context.getBean(JsonMapper.class);
        if (this.jsonMapper instanceof JacksonMapper) {
            ((JacksonMapper)this.jsonMapper).configureObjectMapper(objectMapper -> {
                if (!objectMapper.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) {
                    objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
                }
            });
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Locating function: '" + this.functionDefinition + "'"));
        }
        this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(this.functionDefinition, new String[]{"application/json"});
        if (this.function == null) {
            if (logger.isInfoEnabled()) {
                Set names;
                if (!StringUtils.hasText((String)this.functionDefinition)) {
                    logger.info((Object)"Failed to determine default function. Please use 'spring.cloud.function.definition' property or pass function definition as a constructir argument to this FunctionInvoker");
                }
                if ((names = functionCatalog.getNames(null)).size() == 1) {
                    logger.info((Object)"Will default to RoutingFunction, since it is the only function available in FunctionCatalog.Expecting 'spring.cloud.function.definition' or 'spring.cloud.function.routing-expression' as Message headers. If invocation is over API Gateway, Message headers can be provided as HTTP headers.");
                } else {
                    logger.info((Object)("More then one function is available in FunctionCatalog. " + names + " Will default to RoutingFunction, Expecting 'spring.cloud.function.definition' or 'spring.cloud.function.routing-expression' as Message headers. If invocation is over API Gateway, Message headers can be provided as HTTP headers."));
                }
            }
            this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup("functionRouter", new String[]{"application/json"});
        }
        if (this.function.isOutputTypePublisher()) {
            this.function.setSkipOutputConversion(true);
        }
        Assert.notNull((Object)this.function, (String)("Failed to lookup function " + this.functionDefinition));
        this.functionDefinition = this.function.getFunctionDefinition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Located function: '" + this.functionDefinition + "'"));
        }
    }
}

