/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.WrapperDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.messaging.Message;
import reactor.core.publisher.Flux;

public class FunctionType {
    public static FunctionType UNCLASSIFIED = new FunctionType(ResolvableType.forClassWithGenerics(Function.class, (Class[])new Class[]{Object.class, Object.class}).getType());
    private static List<WrapperDetector> transformers;
    private final Type type;
    private final Class<?> inputType;
    private final Class<?> outputType;
    private final Class<?> inputWrapper;
    private final Class<?> outputWrapper;
    private final boolean message;

    public FunctionType(Type type) {
        this.type = this.functionType(type);
        this.inputWrapper = this.findType(ParamType.INPUT_WRAPPER);
        this.outputWrapper = this.findType(ParamType.OUTPUT_WRAPPER);
        this.inputType = this.findType(ParamType.INPUT);
        this.outputType = this.findType(ParamType.OUTPUT);
        this.message = this.messageType();
    }

    public static boolean isWrapper(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (transformers == null) {
            transformers = new ArrayList<WrapperDetector>();
            transformers.addAll(SpringFactoriesLoader.loadFactories(WrapperDetector.class, null));
        }
        for (WrapperDetector transformer : transformers) {
            if (!transformer.isWrapper(type)) continue;
            return true;
        }
        return false;
    }

    public static FunctionType of(Type function) {
        return new FunctionType(function);
    }

    public static FunctionType from(Class<?> input) {
        return new FunctionType(ResolvableType.forClassWithGenerics(Function.class, (Class[])new Class[]{input, Object.class}).getType());
    }

    public static FunctionType supplier(Class<?> input) {
        return new FunctionType(ResolvableType.forClassWithGenerics(Supplier.class, (Class[])new Class[]{input}).getType());
    }

    public static FunctionType consumer(Class<?> input) {
        return new FunctionType(ResolvableType.forClassWithGenerics(Consumer.class, (Class[])new Class[]{input}).getType());
    }

    public static FunctionType compose(FunctionType input, FunctionType output) {
        ResolvableType inputOutput;
        ResolvableType inputGeneric = FunctionType.input(input);
        ResolvableType outputGeneric = FunctionType.output(output);
        if (!FunctionType.isWrapper(outputGeneric.getType()) && FunctionType.isWrapper((inputOutput = FunctionType.output(input)).getType())) {
            outputGeneric = FunctionType.wrap(input, FunctionType.extractClass(inputOutput.getType(), ParamType.OUTPUT_WRAPPER), FunctionType.extractClass(outputGeneric.getType(), ParamType.OUTPUT));
        }
        return new FunctionType(ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{inputGeneric, outputGeneric}).getType());
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getInputWrapper() {
        return this.inputWrapper;
    }

    public Class<?> getOutputWrapper() {
        return this.outputWrapper;
    }

    public Class<?> getInputType() {
        return this.inputType;
    }

    public Class<?> getOutputType() {
        return this.outputType;
    }

    public boolean isMessage() {
        return this.message;
    }

    public boolean isWrapper() {
        return FunctionType.isWrapper(this.getInputWrapper()) || FunctionType.isWrapper(this.getOutputWrapper());
    }

    public FunctionType to(Class<?> output) {
        ResolvableType inputGeneric = FunctionType.input(this);
        ResolvableType outputGeneric = this.output(output);
        return new FunctionType(ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{inputGeneric, outputGeneric}).getType());
    }

    public FunctionType message() {
        if (this.isMessage()) {
            return this;
        }
        ResolvableType inputGeneric = FunctionType.message(this.getInputType());
        ResolvableType outputGeneric = FunctionType.message(this.getOutputType());
        if (FunctionType.isWrapper(this.getInputWrapper())) {
            inputGeneric = ResolvableType.forClassWithGenerics(this.getInputWrapper(), (ResolvableType[])new ResolvableType[]{inputGeneric});
            outputGeneric = ResolvableType.forClassWithGenerics(this.getInputWrapper(), (ResolvableType[])new ResolvableType[]{outputGeneric});
        }
        return new FunctionType(ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{inputGeneric, outputGeneric}).getType());
    }

    public FunctionType wrap(Class<?> input, Class<?> output) {
        if (!FunctionType.isWrapper(input) && !FunctionType.isWrapper(output)) {
            return this;
        }
        if (FunctionType.isWrapper(input) && FunctionType.isWrapper(output)) {
            if (input.isAssignableFrom(this.getInputWrapper()) && output.isAssignableFrom(this.getOutputWrapper())) {
                return this;
            }
            return new FunctionType(ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{this.wrapper(input, this.getInputType()), this.wrapper(output, this.getOutputType())}).getType());
        }
        throw new IllegalArgumentException("Both wrapper types must be wrappers in (" + input + ", " + output + ")");
    }

    public FunctionType wrap(Class<?> wrapper) {
        return this.wrap(wrapper, wrapper);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputType == null ? 0 : this.inputType.toString().hashCode());
        result = 31 * result + (this.inputWrapper == null ? 0 : this.inputWrapper.toString().hashCode());
        result = 31 * result + (this.message ? 1231 : 1237);
        result = 31 * result + (this.outputType == null ? 0 : this.outputType.toString().hashCode());
        result = 31 * result + (this.outputWrapper == null ? 0 : this.outputWrapper.toString().hashCode());
        return result;
    }

    public String toString() {
        if (this.inputType == Void.class) {
            return this.type.toString() + ", which is effectively a Supplier<" + this.outputType + ">";
        }
        if (this.outputType == Void.class) {
            return this.type.toString() + ", which is effectively a Consumer<" + this.inputType + ">";
        }
        return this.type.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionType other = (FunctionType)obj;
        if (this.inputType == null ? other.inputType != null : !this.inputType.toString().equals(other.inputType.toString())) {
            return false;
        }
        if (this.inputWrapper == null ? other.inputWrapper != null : !this.inputWrapper.toString().equals(other.inputWrapper.toString())) {
            return false;
        }
        if (this.message != other.message) {
            return false;
        }
        if (this.outputType == null ? other.outputType != null : !this.outputType.toString().equals(other.outputType.toString())) {
            return false;
        }
        return !(this.outputWrapper == null ? other.outputWrapper != null : !this.outputWrapper.toString().equals(other.outputWrapper.toString()));
    }

    private static ResolvableType wrap(FunctionType input, Class<?> wrapper, Class<?> type) {
        return input.isMessage() ? FunctionType.wrap(wrapper, FunctionType.message(type)) : ResolvableType.forClassWithGenerics(wrapper, (Class[])new Class[]{type});
    }

    private static ResolvableType wrap(Class<?> wrapper, ResolvableType type) {
        return ResolvableType.forClassWithGenerics(wrapper, (ResolvableType[])new ResolvableType[]{type});
    }

    private static ResolvableType message(Class<?> type) {
        return ResolvableType.forClassWithGenerics(Message.class, (Class[])new Class[]{type});
    }

    private static ResolvableType input(FunctionType type) {
        return type.input(type.getInputType());
    }

    private static ResolvableType output(FunctionType type) {
        return type.output(type.getOutputType());
    }

    private static Class<?> extractClass(Type param, ParamType paramType) {
        if (param instanceof ParameterizedType) {
            ParameterizedType concrete = (ParameterizedType)((Object)param);
            param = concrete.getRawType();
        }
        if (param == null) {
            param = paramType.isWrapper() ? Flux.class : String.class;
        }
        Class result = param instanceof Class ? (Class)param : null;
        return result;
    }

    private ResolvableType wrapper(Class<?> wrapper, Class<?> type) {
        return FunctionType.wrap(this, wrapper, type);
    }

    private ResolvableType output(Class<?> type) {
        ResolvableType raw = ResolvableType.forClass(type);
        if (this.isMessage()) {
            raw = ResolvableType.forClassWithGenerics(Message.class, (ResolvableType[])new ResolvableType[]{raw});
        }
        ResolvableType generic = FunctionType.isWrapper(this.getOutputWrapper()) ? ResolvableType.forClassWithGenerics(this.getOutputWrapper(), (ResolvableType[])new ResolvableType[]{raw}) : raw;
        return generic;
    }

    private ResolvableType input(Class<?> type) {
        ResolvableType raw = ResolvableType.forClass(type);
        if (this.isMessage()) {
            raw = ResolvableType.forClassWithGenerics(Message.class, (ResolvableType[])new ResolvableType[]{raw});
        }
        ResolvableType generic = FunctionType.isWrapper(this.getInputWrapper()) ? ResolvableType.forClassWithGenerics(this.getInputWrapper(), (ResolvableType[])new ResolvableType[]{raw}) : raw;
        return generic;
    }

    private Class<?> findType(ParamType paramType) {
        Class<?> result;
        int index = paramType.isOutput() ? 1 : 0;
        Type type = this.type;
        if (Supplier.class.isAssignableFrom(FunctionType.extractClass(this.type, null)) && paramType.isInput()) {
            return Void.class;
        }
        boolean found = false;
        while (!found && type instanceof Class && type != Object.class) {
            Class clz = type;
            for (Type iface : clz.getGenericInterfaces()) {
                if (!iface.getTypeName().startsWith("java.util.function")) continue;
                type = iface;
                found = true;
                break;
            }
            if (found) continue;
            type = clz.getSuperclass();
        }
        Type param = this.extractType(type, paramType, index);
        if (param != null && (result = FunctionType.extractClass(param, paramType)) != null) {
            return result;
        }
        return Object.class;
    }

    private Type extractType(Type type, ParamType paramType, int index) {
        Object param;
        if (type instanceof ParameterizedType) {
            Type typeArgumentAtIndex;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getActualTypeArguments().length == 1) {
                if (this.isVoid(parameterizedType, paramType)) {
                    return Void.class;
                }
                index = 0;
            }
            if ((typeArgumentAtIndex = parameterizedType.getActualTypeArguments()[index]) instanceof ParameterizedType && !paramType.isWrapper()) {
                if (FunctionType.isWrapper(((ParameterizedType)typeArgumentAtIndex).getRawType())) {
                    param = ((ParameterizedType)typeArgumentAtIndex).getActualTypeArguments()[0];
                    param = this.extractNestedType(paramType, (Type)param);
                } else {
                    param = this.extractNestedType(paramType, typeArgumentAtIndex);
                }
            } else {
                param = this.extractNestedType(paramType, typeArgumentAtIndex);
            }
        } else {
            if (type != null) {
                Type[] interfaces;
                for (Type ifc : interfaces = ((Class)type).getGenericInterfaces()) {
                    Type value = this.extractType(ifc, paramType, index);
                    if (value == Object.class) continue;
                    return value;
                }
            }
            param = Object.class;
        }
        return param;
    }

    private boolean isVoid(ParameterizedType parameterizedType, ParamType paramType) {
        Class<?> rawType = FunctionType.extractClass(parameterizedType.getRawType(), paramType);
        if (Consumer.class.isAssignableFrom(rawType) && paramType.isOutput()) {
            return true;
        }
        return Supplier.class.isAssignableFrom(rawType) && paramType.isInput();
    }

    private Type extractNestedType(ParamType paramType, Type param) {
        if (!paramType.isInnerWrapper() && param instanceof ParameterizedType && ((ParameterizedType)param).getRawType().getTypeName().startsWith(Message.class.getName())) {
            param = ((ParameterizedType)param).getActualTypeArguments()[0];
        }
        return param;
    }

    private Type functionType(Type type) {
        Type product;
        Class<?> output;
        if (Supplier.class.isAssignableFrom(FunctionType.extractClass(type, ParamType.OUTPUT)) && (output = FunctionType.extractClass(product = this.extractType(type, ParamType.OUTPUT, 0), ParamType.OUTPUT)) != null) {
            if (FunctionRegistration.class.isAssignableFrom(output)) {
                type = this.extractType(product, ParamType.OUTPUT, 0);
            } else if (Function.class.isAssignableFrom(output) || Supplier.class.isAssignableFrom(output) || Consumer.class.isAssignableFrom(output)) {
                type = product;
            }
        }
        return type;
    }

    private boolean messageType() {
        Class<?> inputType = this.findType(ParamType.INPUT_INNER_WRAPPER);
        Class<?> outputType = this.findType(ParamType.OUTPUT_INNER_WRAPPER);
        return inputType.getName().startsWith(Message.class.getName()) || Message.class.isAssignableFrom(inputType) || outputType.getName().startsWith(Message.class.getName()) || Message.class.isAssignableFrom(outputType);
    }

    static enum ParamType {
        INPUT,
        OUTPUT,
        INPUT_WRAPPER,
        OUTPUT_WRAPPER,
        INPUT_INNER_WRAPPER,
        OUTPUT_INNER_WRAPPER;


        public boolean isOutput() {
            return this == OUTPUT || this == OUTPUT_WRAPPER || this == OUTPUT_INNER_WRAPPER;
        }

        public boolean isInput() {
            return this == INPUT || this == INPUT_WRAPPER || this == INPUT_INNER_WRAPPER;
        }

        public boolean isWrapper() {
            return this == OUTPUT_WRAPPER || this == INPUT_WRAPPER;
        }

        public boolean isInnerWrapper() {
            return this == OUTPUT_INNER_WRAPPER || this == INPUT_INNER_WRAPPER;
        }
    }
}

