/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.integration.dsl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.util.Assert;

public class FunctionLookupHelper {
    private final FunctionCatalog functionCatalog;

    FunctionLookupHelper(FunctionCatalog functionCatalog) {
        this.functionCatalog = functionCatalog;
    }

    <P> Supplier<P> lookupSupplier(String functionDefinition) {
        Supplier memoizedSupplier = this.lazyLookup(Supplier.class, functionDefinition);
        return () -> ((Supplier)memoizedSupplier.get()).get();
    }

    <P> Function<P, ?> lookupFunction(String functionDefinition) {
        Supplier memoizedFunction = this.lazyLookup(Function.class, functionDefinition);
        return p -> ((Function)memoizedFunction.get()).apply(p);
    }

    <P> Consumer<P> lookupConsumer(String consumerDefinition) {
        Supplier memoizedConsumer = this.lazyLookup(Consumer.class, consumerDefinition);
        return p -> ((Consumer)memoizedConsumer.get()).accept(p);
    }

    private <T> Supplier<T> lazyLookup(Class<?> functionType, String functionDefinition) {
        return FunctionLookupHelper.memoize(() -> this.requireNonNull(functionType, functionDefinition));
    }

    private <T> T requireNonNull(Class<?> functionType, String functionDefinition) {
        Object function = this.functionCatalog.lookup(functionType, functionDefinition);
        Assert.notNull((Object)function, () -> "No '" + functionDefinition + "' in the catalog");
        return (T)function;
    }

    private static <T> Supplier<T> memoize(Supplier<? extends T> delegate) {
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                AtomicReference atomicReference = value;
                synchronized (atomicReference) {
                    val = value.get();
                    if (val == null) {
                        val = delegate.get();
                        value.set(val);
                    }
                }
            }
            return val;
        };
    }
}

