/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.springframework.cloud.function.serverless.web.ProxyHttpSession;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ProxyHttpServletRequest
implements HttpServletRequest {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final BufferedReader EMPTY_BUFFERED_READER = new BufferedReader(new StringReader(""));
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    private final ServletContext servletContext;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    @Nullable
    private String characterEncoding;
    @Nullable
    private byte[] content;
    @Nullable
    private ServletInputStream inputStream;
    @Nullable
    private BufferedReader reader;
    private final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>(16);
    private final LinkedList<Locale> locales = new LinkedList();
    private boolean asyncStarted = false;
    private boolean asyncSupported = false;
    private DispatcherType dispatcherType = DispatcherType.REQUEST;
    @Nullable
    private String authType;
    @Nullable
    private Cookie[] cookies;
    private final HttpHeaders headers = new HttpHeaders();
    @Nullable
    private String method;
    @Nullable
    private String pathInfo;
    private String contextPath = "";
    @Nullable
    private String queryString;
    @Nullable
    private String remoteUser;
    private final Set<String> userRoles = new HashSet<String>();
    @Nullable
    private Principal userPrincipal;
    @Nullable
    private String requestedSessionId;
    @Nullable
    private String requestURI;
    private String servletPath = "";
    @Nullable
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    private final MultiValueMap<String, Part> parts = new LinkedMultiValueMap();

    public ProxyHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this.servletContext = servletContext;
        this.method = method;
        this.requestURI = requestURI;
        this.locales.add(Locale.ENGLISH);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(@Nullable String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(@Nullable byte[] content) {
        this.content = content;
        this.inputStream = null;
        this.reader = null;
    }

    @Nullable
    public byte[] getContentAsByteArray() {
        return this.content;
    }

    @Nullable
    public String getContentAsString() throws IllegalStateException, UnsupportedEncodingException {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public void setContentType(@Nullable String contentType) {
        this.headers.set("Content-Type", contentType);
    }

    @Nullable
    public String getContentType() {
        return this.headers.containsKey((Object)"Content-Type") ? (String)this.headers.get((Object)"Content-Type").get(0) : null;
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream stream = new ByteArrayInputStream(this.content);
        return new ServletInputStream(){
            boolean finished = false;

            public int read() throws IOException {
                int readByte = stream.read();
                if (readByte == -1) {
                    this.finished = true;
                }
                return readByte;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public boolean isReady() {
                return !this.finished;
            }

            public boolean isFinished() {
                return this.finished;
            }
        };
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String ... values) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.put(name, values);
    }

    public void setParameters(Map<String, ?> params) {
        Assert.notNull(params, (String)"Parameter map must not be null");
        params.forEach((key, value) -> {
            if (value instanceof String) {
                this.setParameter((String)key, (String)value);
            } else if (value instanceof String[]) {
                this.setParameter((String)key, (String[])value);
            } else {
                throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
            }
        });
    }

    public void addParameter(String name, @Nullable String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String ... values) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        String[] oldArr = this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void addParameters(Map<String, ?> params) {
        Assert.notNull(params, (String)"Parameter map must not be null");
        params.forEach((key, value) -> {
            if (value instanceof String) {
                this.addParameter((String)key, (String)value);
            } else if (value instanceof String[]) {
                this.addParameter((String)key, (String[])value);
            } else {
                throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
            }
        });
    }

    public void removeParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.remove(name);
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    @Nullable
    public String getParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "https";
    }

    public void setServerName(String serverName) {
        throw new UnsupportedOperationException();
    }

    public String getServerName() {
        return "spring-serverless-web-proxy";
    }

    public void setServerPort(int serverPort) {
        throw new UnsupportedOperationException();
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.reader != null) {
            return this.reader;
        }
        if (this.inputStream != null) {
            throw new IllegalStateException("Cannot call getReader() after getInputStream() has already been called for the current request");
        }
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            this.reader = new BufferedReader(sourceReader);
        } else {
            this.reader = EMPTY_BUFFERED_READER;
        }
        return this.reader;
    }

    public void setRemoteAddr(String remoteAddr) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return "proxy";
    }

    public void setRemoteHost(String remoteHost) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Locale getLocale() {
        return this.locales.getFirst();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public void setRemotePort(int remotePort) {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public void setLocalName(String localName) {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public void setLocalAddr(String localAddr) {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        return "proxy";
    }

    public void setLocalPort(int localPort) {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, null);
    }

    public AsyncContext startAsync(ServletRequest request, @Nullable ServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted = asyncStarted;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncContext(@Nullable AsyncContext asyncContext) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public AsyncContext getAsyncContext() {
        return null;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setAuthType(@Nullable String authType) {
        this.authType = authType;
    }

    @Nullable
    public String getAuthType() {
        return this.authType;
    }

    @Nullable
    public Cookie[] getCookies() {
        return this.cookies;
    }

    @Nullable
    public String getHeader(String name) {
        return this.headers.containsKey((Object)name) ? this.headers.get((Object)name).toString() : null;
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.headers.containsKey((Object)name) ? this.headers.get((Object)name) : new LinkedList());
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public void setHeader(String name, @Nullable String value) {
        this.headers.set(name, value);
    }

    public void addHeader(String name, @Nullable String value) {
        this.headers.add(name, value);
    }

    public void addHeaders(MultiValueMap<String, String> headers) {
        this.headers.addAll(headers);
    }

    public void setHeaders(MultiValueMap<String, String> headers) {
        this.headers.clear();
        this.addHeaders(headers);
    }

    public int getIntHeader(String name) {
        List header = this.headers.get((Object)name);
        if (!CollectionUtils.isEmpty((Collection)header) && header.size() == 1) {
            Object value = header.get(0);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value != null) {
                throw new NumberFormatException("Value for header '" + name + "' is not a Number: " + value);
            }
            return -1;
        }
        return -1;
    }

    public long getDateHeader(String name) {
        List header = this.headers.get((Object)name);
        if (!CollectionUtils.isEmpty((Collection)header) && header.size() == 1) {
            Object value = header.get(0);
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return this.parseDateHeader(name, (String)value);
            }
            if (value != null) {
                throw new IllegalArgumentException("Value for header '" + name + "' is not a Date, Number, or String: " + value);
            }
            return -1L;
        }
        return -1L;
    }

    private long parseDateHeader(String name, String value) {
        for (String dateFormat : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
            simpleDateFormat.setTimeZone(GMT);
            try {
                return simpleDateFormat.parse(value).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse date value '" + value + "' for '" + name + "' header");
    }

    public void setMethod(@Nullable String method) {
        this.method = method;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(@Nullable String pathInfo) {
        this.pathInfo = pathInfo;
    }

    @Nullable
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Nullable
    public String getPathTranslated() {
        return this.pathInfo;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setQueryString(@Nullable String queryString) {
        this.queryString = queryString;
    }

    @Nullable
    public String getQueryString() {
        return this.queryString;
    }

    public void setRemoteUser(@Nullable String remoteUser) {
        this.remoteUser = remoteUser;
    }

    @Nullable
    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public void setUserPrincipal(@Nullable Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    @Nullable
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setRequestedSessionId(@Nullable String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    @Nullable
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public void setRequestURI(@Nullable String requestURI) {
        this.requestURI = requestURI;
    }

    @Nullable
    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURI);
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public HttpSession getSession(boolean create) {
        if (this.session == null) {
            this.session = new ProxyHttpSession(this.servletContext);
        }
        return this.session;
    }

    @Nullable
    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        this.userPrincipal = null;
        this.remoteUser = null;
        this.authType = null;
    }

    public void addPart(Part part) {
        this.parts.add((Object)part.getName(), (Object)part);
    }

    @Nullable
    public Part getPart(String name) throws IOException, ServletException {
        return (Part)this.parts.getFirst((Object)name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LinkedList<Part> result = new LinkedList<Part>();
        for (List list : this.parts.values()) {
            result.addAll(list);
        }
        return result;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getRequestId() {
        return null;
    }

    public String getProtocolRequestId() {
        return null;
    }

    public ServletConnection getServletConnection() {
        return null;
    }
}

