/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.flux.FunctionController;
import org.springframework.cloud.function.web.flux.constants.WebRequestConstants;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
public class FunctionHandlerMapping
extends RequestMappingHandlerMapping
implements InitializingBean {
    private final FunctionCatalog functions;
    private final FunctionController controller;
    @Value(value="${spring.cloud.function.web.path:}")
    private String prefix = "";
    @Value(value="${debug:${DEBUG:false}}")
    private String debug = "false";

    @Autowired
    public FunctionHandlerMapping(FunctionCatalog catalog, FunctionController controller) {
        this.functions = catalog;
        this.logger.info((Object)("FunctionCatalog: " + catalog));
        this.setOrder(super.getOrder() - 5);
        this.controller = controller;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.controller.setDebug(!"false".equals(this.debug));
        this.detectHandlerMethods(this.controller);
        while (this.prefix.endsWith("/")) {
            this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
        }
    }

    protected void initHandlerMethods() {
    }

    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        HandlerMethod handler = super.getHandlerInternal(request);
        if (handler == null) {
            return null;
        }
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (StringUtils.hasText((String)this.prefix) && !path.startsWith(this.prefix)) {
            return null;
        }
        if (path.startsWith(this.prefix)) {
            path = path.substring(this.prefix.length());
        }
        if (path == null) {
            return handler;
        }
        Object function = this.findFunctionForGet(request, path);
        if (function != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found function for GET: " + path));
            }
            request.setAttribute(WebRequestConstants.HANDLER, function);
            return handler;
        }
        function = this.findFunctionForPost(request, path);
        if (function != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found function for POST: " + path));
            }
            request.setAttribute(WebRequestConstants.HANDLER, function);
            return handler;
        }
        return null;
    }

    private Object findFunctionForPost(HttpServletRequest request, String path) {
        if (!request.getMethod().equals("POST")) {
            return null;
        }
        Consumer consumer = (Consumer)this.functions.lookup(Consumer.class, path = path.startsWith("/") ? path.substring(1) : path);
        if (consumer != null) {
            request.setAttribute(WebRequestConstants.CONSUMER, (Object)consumer);
            return consumer;
        }
        Function function = (Function)this.functions.lookup(Function.class, path);
        if (function != null) {
            request.setAttribute(WebRequestConstants.FUNCTION, (Object)function);
            return function;
        }
        return null;
    }

    private Object findFunctionForGet(HttpServletRequest request, String path) {
        if (!request.getMethod().equals("GET")) {
            return null;
        }
        Supplier supplier = (Supplier)this.functions.lookup(Supplier.class, path = path.startsWith("/") ? path.substring(1) : path);
        if (supplier != null) {
            request.setAttribute(WebRequestConstants.SUPPLIER, (Object)supplier);
            return supplier;
        }
        StringBuilder builder = new StringBuilder();
        String name = path;
        String value = null;
        for (String element : path.split("/")) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(element);
            name = builder.toString();
            value = path.length() > name.length() ? path.substring(name.length() + 1) : null;
            Function function = (Function)this.functions.lookup(Function.class, name);
            if (function == null) continue;
            request.setAttribute(WebRequestConstants.FUNCTION, (Object)function);
            request.setAttribute(WebRequestConstants.ARGUMENT, (Object)value);
            return function;
        }
        return null;
    }
}

