/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux.request;

import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.cloud.function.context.catalog.FunctionInspector;

public abstract class DelegateHandler<T> {
    private final ListableBeanFactory factory;
    private FunctionInspector processor;
    private Object handler;
    private final Object source;

    public DelegateHandler(ListableBeanFactory factory, Object source) {
        this.factory = factory;
        this.source = source;
    }

    public Class<?> type() {
        return this.processor().getInputType(this.handler());
    }

    private Object handler() {
        if (this.handler == null) {
            this.handler = this.source instanceof String ? this.factory.getBean((String)this.source) : this.source;
        }
        return this.handler;
    }

    private FunctionInspector processor() {
        if (this.processor == null) {
            this.processor = (FunctionInspector)this.factory.getBean(FunctionInspector.class);
        }
        return this.processor;
    }
}

